DELIMITER $$
DROP PROCEDURE IF EXISTS V20240425144050__Create_ExamBulkResultPublish $$
CREATE PROCEDURE V20240425144050__Create_ExamBulkResultPublish()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_bulk_result_publish')) THEN 
CREATE TABLE `exam_bulk_result_publish` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT NOT NULL,
  `academicTermId` BIGINT NOT NULL,
  `evaluationPlanId` BIGINT NOT NULL,
  `filterPlanId` BIGINT NULL,
  `typeId` BIGINT DEFAULT NULL,
  `subTypeId` BIGINT DEFAULT NULL,
  `methodId` BIGINT DEFAULT NULL,
  `eventId` BIGINT DEFAULT NULL,
  `programId` BIGINT DEFAULT NULL,
  `batchId` BIGINT DEFAULT NULL,
  `periodId` BIGINT DEFAULT NULL ,
  `courseIds` TEXT DEFAULT NULL,
  `status` BOOLEAN default FALSE,
  `whetherPublish` BOOLEAN default TRUE,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT now(),
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
   CONSTRAINT `fk_exam_bulk_result_publish_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
  );
END IF; 
END $$
CALL V20240425144050__Create_ExamBulkResultPublish () $$ 
DROP PROCEDURE IF EXISTS V20240425144050__Create_ExamBulkResultPublish $$ 
DELIMITER ;