DELIMITER $$
DROP PROCEDURE IF EXISTS V20240515111430__Create_payment_link_bills $$
CREATE PROCEDURE V20240515111430__Create_payment_link_bills()
BEGIN
 
IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_link_bills')) THEN 
CREATE TABLE payment_link_bills (
id bigint(20) NOT NULL AUTO_INCREMENT,
paymentLinkId bigint(20),
billHeaderId bigint(20),
totalOutstandingAmount double(20,3) DEFAULT NULL,
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
PRIMARY KEY (id),

CONSTRAINT `FK_payment_link_bills_FK_paymentLinkId` FOREIGN KEY (`paymentLinkId`) REFERENCES `payment_link` (`id`),
CONSTRAINT `FK_payment_link_bills_FK_billHeaderId` FOREIGN KEY (`billHeaderId`) REFERENCES `bill_header` (`id`),
CONSTRAINT `FK_payment_link_bills_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) ;
END IF; 

END $$
CALL V20240515111430__Create_payment_link_bills () $$ 
DROP PROCEDURE IF EXISTS V20240515111430__Create_payment_link_bills $$ 
DELIMITER ;




 