DELIMITER $$
DROP PROCEDURE IF EXISTS V20240516165424__Create_dtef_course_enrollment_mapping $$
CREATE PROCEDURE V20240516165424__Create_dtef_course_enrollment_mapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='dtef_course_enrollment_mapping')) THEN 
CREATE TABLE `dtef_course_enrollment_mapping` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT(20) NULL,
  `periodId` BIGINT(20) NULL,
  `studentCourseEnrollmentIds` BIGINT(20) NULL,
  `programBatchStudentId` BIGINT(20) NULL,
  `responseStatus` VARCHAR(255) NULL,
  `response` VARCHAR(255) NULL,
  `responseDate` TIMESTAMP NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `admissionFK_idx` (`admissionId` ASC) ,
  INDEX `periodFK_idx` (`periodId` ASC) ,
  INDEX `studentCourseEnrollementFK_idx` (`studentCourseEnrollmentIds` ASC) ,
  INDEX `programBatchStudentFK_idx` (`programBatchStudentId` ASC) ,
  INDEX `lastUpdatedByFK_idx` (`lastUpdatedBy` ASC) ,
  CONSTRAINT `admissionFK`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`),
  CONSTRAINT `periodFK`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `studentCourseEnrollementFK`
    FOREIGN KEY (`studentCourseEnrollmentIds`)
    REFERENCES `student_course_enrollment` (`id`),
  CONSTRAINT `programBatchStudentFK`
    FOREIGN KEY (`programBatchStudentId`)
    REFERENCES `program_batch_students` (`id`),
  CONSTRAINT `lastUpdatedByFK`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`));

END IF; 

END $$
CALL V20240516165424__Create_dtef_course_enrollment_mapping () $$ 
DROP PROCEDURE IF EXISTS V20240516165424__Create_dtef_course_enrollment_mapping $$ 
DELIMITER ;