DELIMITER $$
DROP PROCEDURE IF EXISTS V20240521173649__Update_HostelAllocationApplicant $$
CREATE PROCEDURE V20240521173649__Update_HostelAllocationApplicant()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_ALLOCATION_RECIPIENT')) THEN 
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_ALLOCATION_RECIPIENT');
UPDATE sql_dtprovider
SET sqlQuery = "SELECT
	DISTINCT
    T1.id AS ID,
    T1.allocationDate AS ALLOCATION_DATE,
    T11.printName AS ALLOCATED_BY,
    T6.code AS APPLICATION_ID,
    T5.printName AS APP_PRINT_NAME,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.emailId AS EMAIL_ID,
    T5.firstName AS APP_FIRST_NAME,
    T5.middleName AS APP_MIDDLE_NAME,
    T5.lastName AS APP_LAST_NAME,
    T5.externalSysRefOne AS EXTERNAL_REFERENCE_NUMBER_1,
    T5.initials AS INITIALS,
    T9.salutationName AS TITLE,
    T4.code AS HOSTEL_CODE,
    T4.resourceName AS HOSTEL_NAME,
    T7.logoUrl AS LOGO_URL,
    'APPLICANT' AS USER_TYPE_KEY,
    ml.code AS LANGUAGE_KEY,
    T10.itemValue AS ACADEMIC_YEAR,
    T13.locationName AS HOSTEL_LOCATION,
    (CASE
        WHEN
            T7.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T7.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM
    applicant_hostel_requirement T1
        LEFT OUTER JOIN
    hostel_application_setup T2 ON T1.waitingListTypeSetupId = T2.id
        LEFT OUTER JOIN
    resources T4 ON T1.resourceId = T4.id
        LEFT OUTER JOIN
    applicant_person T5 ON T1.applicantPersonId = T5.id
        LEFT OUTER JOIN
    application T6 ON T6.applicantPersonId = T5.id
        LEFT OUTER JOIN
    academy_location T7 ON T7.id = T1.academyLocationId
        LEFT OUTER JOIN
    multi_language ml ON ml.id = T5.correspondence_language
        LEFT OUTER JOIN
    salutations T9 ON T5.salutationId = T9.id
        LEFT OUTER JOIN
    academic_term T10 ON T2.year = T10.id
        LEFT OUTER JOIN
    users T11 ON T1.allocatedById = T11.id
        LEFT OUTER JOIN
   resource_academy_locations T12 on  T12.resourceId = T4.id and whetherPrimary = 1
        LEFT OUTER JOIN
   academy_location  T13 on T13.id = T12.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN  (namedParams) ",
    jsonString = '{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "APP_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "APP_LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "APP_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		
		{
            "id": 5,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "code",
            "resultKey": "HOSTEL_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "resourceName",
            "resultKey": "HOSTEL_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "allocationDate",
            "resultKey": "ALLOCATION_DATE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "allocatedBy",
            "resultKey": "ALLOCATED_BY",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "applicantPrintName",
            "resultKey": "APP_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
         {
            "id": 13,
            "value": "externalSysRefOne",
            "resultKey": "EXTERNAL_REFERENCE_NUMBER_1",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "initials",
            "resultKey": "INITIALS",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "title",
            "resultKey": "TITLE",
            "displayCode": "",
            "displayOrder": 14
        },
         {
            "id": 16,
            "value": "academicYear",
            "resultKey": "ACADEMIC_YEAR",
            "displayCode": "",
            "displayOrder": 15
        },
         {
            "id": 17,
            "value": "hostelLocation",
            "resultKey": "HOSTEL_LOCATION",
            "displayCode": "",
            "displayOrder": 16
        }
    ]
 }'
    where dataProviderId = @dtproviderId;
    
    SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 IF EXISTS (select id from msg_template_config where code = "Hostel Allocation" limit 1) THEN
    
	   SET @msgtemplateconfigId=(select id from msg_template_config where code = "Hostel Allocation Student" limit 1);
       INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
       VALUES (@msgtemplateId+1,@msgtemplateconfigId,'2','Hostel Allocation','');
 
       INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
       VALUES (@msgtemplateId+2,@msgtemplateconfigId,'6','Hostel Allocation','');
    
 END IF; 
 
    
    
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240521173649__Update_HostelAllocationApplicant () $$
DROP PROCEDURE IF EXISTS V20240521173649__Update_HostelAllocationApplicant $$
DELIMITER ;