DELIMITER $$
DROP PROCEDURE IF EXISTS V20240529151954__Create_PostGraduateSendDocEvent $$
CREATE PROCEDURE V20240529151954__Create_PostGraduateSendDocEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='POST_GRADUATE_SEND_DOCUMENT')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'POST_GRADUATE_SEND_DOCUMENT');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='POST_GRADUATE_SEND_DOCUMENT');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'POST_GRADUATE_SEND_DOCUMENT', 'Post Graduate Send Document', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Post Graduate Send Document');
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'POST_GRADUATE_SEND_DOCUMENT_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'POST_GRADUATE_SEND_DOCUMENT_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='POST_GRADUATE_SEND_DOCUMENT_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'POST_GRADUATE_SEND_DOCUMENT_RECIPIENT');
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='POST_GRADUATE_SEND_DOCUMENT_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='POST_GRADUATE_SEND_DOCUMENT_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='POST_GRADUATE_SEND_DOCUMENT_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID FROM student_examiner_thesis_document T1 WHERE T1.id IN (namedParams)",NULL);
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='POST_GRADUATE_SEND_DOCUMENT_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT
    T1.id AS ID,
	T3.firstName AS FIRST_NAME,
	T3.middleName AS MIDDLE_NAME,
	T3.lastName AS LAST_NAME,
	T3.printName AS PRINT_NAME,
	T3.emailId AS EMAIL_ID,
	T3.firstName AS EXAMINER_FIRST_NAME,
	T3.middleName AS EXAMINER_MIDDLE_NAME,
	T3.lastName AS EXAMINER_LAST_NAME,
	T3.printName AS EXAMINER_PRINT_NAME,
	T4.salutationName AS EXAMINER_SALUTATION,
	T5.firstName AS STUDENT_FIRST_NAME,
	T5.middleName AS STUDENT_MIDDLE_NAME,
	T5.lastName AS STUDENT_LAST_NAME,
	T5.printName AS STUDENT_PRINT_NAME,
	T6.salutationName AS STUDENT_SALUTATION,
	(SELECT S2.salutationName FROM person_functionary_details P1
        LEFT OUTER JOIN persons P2 ON P2.id = P1.personId
        LEFT OUTER JOIN functionary_type F1 ON F1.id = P1.functionaryTypeId
		LEFT OUTER JOIN staffs S1 ON S1.userId = P1.functionaryUserId
		LEFT OUTER JOIN persons P3 ON P3.id = S1.personId
		LEFT OUTER JOIN salutations S2 ON S2.id = P3.salutationId
        WHERE P1.personId = T1.personId AND P1.activeStatus = true 
			AND F1.itemCode = 'Internal Supervisor' LIMIT 1) AS INTERNAL_SUPERVISOR_SALUTATION,
	(SELECT U1.printName FROM person_functionary_details P1
        LEFT OUTER JOIN persons P2 ON P2.id = P1.personId
        LEFT OUTER JOIN functionary_type F1 ON F1.id = P1.functionaryTypeId
		LEFT OUTER JOIN users U1 ON U1.id = P1.functionaryUserId
        WHERE P1.personId = T1.personId AND P1.activeStatus = true 
			AND F1.itemCode = 'Internal Supervisor' LIMIT 1) AS INTERNAL_SUPERVISOR,
	T8.path AS DOCUMENT_URL,
	T8.documentName AS DOCUMENT_NAME,
    date(now()) AS CURRENTDATE
FROM
    student_examiner_thesis_document T1
		LEFT OUTER JOIN 
    staffs T2 ON T2.userId = T1.examinerId
		LEFT OUTER JOIN 
    persons T3 ON T3.id = T2.personId
		LEFT OUTER JOIN 
    salutations T4 ON T4.id = T3.salutationId
		LEFT OUTER JOIN 
    persons T5 ON T5.id = T1.personId
		LEFT OUTER JOIN 
    salutations T6 ON T6.id = T5.salutationId
		LEFT OUTER JOIN
	student_thesis_document T7 ON T7.studentExamThesisDocId = T1.id
		LEFT OUTER JOIN
	documents T8 ON T8.id = T7.documentId
WHERE
    T1.id IN (namedParams)",'{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
		{
            "id": 2,
            "value": "firstName",
            "resultKey": "EXAMINER_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
		{
            "id": 3,
            "value": "middleName",
            "resultKey": "EXAMINER_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
		{
            "id": 4,
            "value": "lastName",
            "resultKey": "EXAMINER_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "printName",
            "resultKey": "EXAMINER_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "salutationName",
            "resultKey": "EXAMINER_SALUTATION",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "salutationName",
            "resultKey": "STUDENT_SALUTATION",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "printName",
            "resultKey": "INTERNAL_SUPERVISOR",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "CURRENTDATE",
            "resultKey": "CURRENTDATE",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "salutationName",
            "resultKey": "INTERNAL_SUPERVISOR_SALUTATION",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='POST_GRADUATE_SEND_DOCUMENT_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='POST_GRADUATE_SEND_DOCUMENT');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='POST_GRADUATE_SEND_DOCUMENT');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='POST_GRADUATE_SEND_DOCUMENT_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Post Graduate Send Document',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Post Graduate Send Document',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','<html>
<head>
	<title></title>
</head>
<body>
<p>#foreach ($Data in $recipientData[&quot;MultipleDocumentUrl&quot;])</p>

<p><a href="$Data.documentUrl" target="_blank">$Data.documentName</a></p>

<p>#end</p>
</body>
</html>');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','','<html>
<head>
	<title></title>
</head>
<body>
<p>#foreach ($Data in $recipientData[&quot;MultipleDocumentUrl&quot;])</p>

<p><a href="$Data.documentUrl" target="_blank">$Data.documentName</a></p>

<p>#end</p>
</body>
</html>');
 
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='POST_GRADUATE_SEND_DOCUMENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'POST_GRADUATE_SEND_DOCUMENT', 'Post Graduate Send Document', 'Post Graduate Send Document', 'Nagraadse Stuur dokument', 'Sau đại học Gửi tài liệu',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='POST_GRADUATE_SEND_DOCUMENT_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'POST_GRADUATE_SEND_DOCUMENT_DL', 'Post Graduate Send Document DL', 'Post Graduate Send Document DL', 'Nagraadse Stuur dokument DL', 'Sau đại học Gửi hồ sơ DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='POST_GRADUATE_SEND_DOCUMENT_RECIPIENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'POST_GRADUATE_SEND_DOCUMENT_RECIPIENT', 'Post Graduate Send Document Recipient', 'Post Graduate Send Document Recipient', 'Nagraadse Stuur dokumentontvanger', 'Sau đại học Gửi người nhận tài liệu',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='POST_GRADUATE_SEND_DOCUMENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('POST_GRADUATE_SEND_DOCUMENT', 'Post Graduate Send Document');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='POST_GRADUATE_SEND_DOCUMENT_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('POST_GRADUATE_SEND_DOCUMENT_DL', 'Post Graduate Send Document DL');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='POST_GRADUATE_SEND_DOCUMENT_RECIPIENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('POST_GRADUATE_SEND_DOCUMENT_RECIPIENT', 'Post Graduate Send Document Recipient');
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EXAMINER_FIRST_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'EXAMINER_FIRST_NAME', 'Examiner First Name', 'Examiner First Name', 'Eksaminator Voornaam', 'Tên người kiểm tra',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EXAMINER_MIDDLE_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'EXAMINER_MIDDLE_NAME', 'Examiner Middle Name', 'Examiner Middle Name', 'Eksaminator Middelnaam', 'Tên đệm của giám khảo',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EXAMINER_LAST_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'EXAMINER_LAST_NAME', 'Examiner Last Name', 'Examiner Last Name', 'Eksaminator Van', 'Họ của người kiểm tra',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EXAMINER_PRINT_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'EXAMINER_PRINT_NAME', 'Examiner Print Name', 'Examiner Print Name', 'Eksaminator Druk Naam', 'Tên in của giám khảo',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EXAMINER_SALUTATION')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'EXAMINER_SALUTATION', 'Examiner Salutation', 'Examiner Salutation', 'Eksaminator groet', 'Lời chào giám khảo',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='INTERNAL_SUPERVISOR')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'INTERNAL_SUPERVISOR', 'Internal Supervisor', 'Internal Supervisor', 'Interne Toesighouer', 'Giám sát nội bộ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='INTERNAL_SUPERVISOR_SALUTATION')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'INTERNAL_SUPERVISOR_SALUTATION', 'Internal Supervisor Salutation', 'Internal Supervisor Salutation', 'Interne Toesighouer Salutasie', 'Lời chào của Giám sát nội bộ',now(),1);
END IF;

END $$
CALL V20240529151954__Create_PostGraduateSendDocEvent () $$ 
DROP PROCEDURE IF EXISTS V20240529151954__Create_PostGraduateSendDocEvent $$ 
DELIMITER ;