DELIMITER $$
DROP PROCEDURE IF EXISTS V20240626113504__Create_CurrentPersonDisability $$
CREATE PROCEDURE V20240626113504__Create_CurrentPersonDisability()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='current_person_disability')) THEN 
CREATE TABLE `current_person_disability` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `haveDisabilityId` BIGINT NOT NULL,
  `personId` BIGINT NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_current_person_disabilty_idx` (`haveDisabilityId`),
  INDEX `fk_current_person_disability_lastUpdateBy_idx` (`lastUpdatedBy`),
  INDEX `fk_current_person_Id_idx` (`personId`),
  CONSTRAINT `fk_current_person_disabilityId`
    FOREIGN KEY (`haveDisabilityId`)
    REFERENCES `drop_down` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_current_person_Id_idx`
    FOREIGN KEY (`personId`)
    REFERENCES `persons` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_current_person_disability_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF;

END $$
CALL V20240626113504__Create_CurrentPersonDisability () $$ 
DROP PROCEDURE IF EXISTS V20240626113504__Create_CurrentPersonDisability $$ 
DELIMITER ;