DELIMITER $$
DROP PROCEDURE IF EXISTS V20240627183814__Update_AdmissionInfo_dateFomat_dateOfBirth $$
CREATE PROCEDURE V20240627183814__Update_AdmissionInfo_dateFomat_dateOfBirth()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item d WHERE d.dataSourceCode='ADMISSION_INFO')) THEN 
SET @dydtDataLineItemId=(select id from dydt_data_line_item d WHERE d.dataSourceCode='ADMISSION_INFO' and publishAsParametersDef is not null limit 1);
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT p.firstName AS student_firstname ,p.lastName AS student_lastname ,p.middleName 
    AS student_middlename,p.gender AS student_gender,p.printName  AS student_printname,
    sln.salutationName AS applicant_salutation,DATE_FORMAT(p.birthDate, \'%d-%m-%Y\') AS birth_date,cc.itemCode as 
    student_caste,r.itemCode as student_religion,cou.countryName as student_country  , user.code as student_code 
    FROM students s LEFT JOIN  persons p ON s.personId = p.id LEFT JOIN salutations sln ON 
    p.salutationId = sln.id LEFT JOIN caste_categories cc ON p.castCategoryId=cc.id 
    LEFT JOIN religions r ON p.religionId=r.id LEFT JOIN country cou ON p.countryId=cou.id
    LEFT JOIN users user ON s.userId=user.id'
    WHERE id =@dydtDataLineItemId;
    
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240627183814__Update_AdmissionInfo_dateFomat_dateOfBirth () $$
DROP PROCEDURE IF EXISTS V20240627183814__Update_AdmissionInfo_dateFomat_dateOfBirth $$
DELIMITER ;