DELIMITER $$
DROP PROCEDURE IF EXISTS V20240710184445__Create_Qualification_HEQF_Level $$
CREATE PROCEDURE V20240710184445__Create_Qualification_HEQF_Level()
BEGIN

 IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='qualification_heqf_level')) THEN 
CREATE TABLE qualification_heqf_level(
    id BIGINT(20) NOT NULL AUTO_INCREMENT, 
    itemCode VARCHAR(255) NOT NULL ,
    itemValue VARCHAR(255) NOT NULL,
    lastUpdatedBy BIGINT(20)NOT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP on update current_timestamp,
    PRIMARY KEY (id),
    UNIQUE(itemCode)
    );
    
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'qualification_heqf_level','Qualification HEQF Level','Fees & Payments','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());
END IF;

END $$
CALL V20240710184445__Create_Qualification_HEQF_Level () $$ 
DROP PROCEDURE IF EXISTS V20240710184445__Create_Qualification_HEQF_Level $$ 
DELIMITER ;