DELIMITER $$
DROP PROCEDURE IF EXISTS V20240715110308__Create_CeremonyAL $$
CREATE PROCEDURE V20240715110308__Create_CeremonyAL()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='ceremony_academy_location')) THEN  
CREATE TABLE `ceremony_academy_location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ceremonyId` BIGINT(20) NOT NULL,
  `academyLocationId` BIGINT(20) DEFAULT NULL,
  `programGroupId` BIGINT(20) DEFAULT NULL,
  `progBatchPeriodConfigId` BIGINT(20) DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   PRIMARY KEY (`id`),
  KEY `index2` (`academyLocationId`),
  KEY `index3` (`lastUpdatedBy`),
  KEY `index4` (`ceremonyId`),
  KEY `index5` (`programGroupId`),
  KEY `index6` (`progBatchPeriodConfigId`),
  CONSTRAINT `fk_ceremony_academy_location_1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) 
  ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_ceremony_academy_location_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) 
  ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_ceremony_academy_location_3` FOREIGN KEY (`ceremonyId`) REFERENCES `ceremony` (`id`) 
  ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_ceremony_academy_location_4` FOREIGN KEY (`programGroupId`) REFERENCES `program_group` (`id`) 
  ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_ceremony_academy_location_5` FOREIGN KEY (`progBatchPeriodConfigId`) REFERENCES `prog_batch_period_config` (`id`) 
  ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF;  

END $$
CALL V20240715110308__Create_CeremonyAL () $$ 
DROP PROCEDURE IF EXISTS V20240715110308__Create_CeremonyAL $$ 
DELIMITER ;