DELIMITER $$
DROP PROCEDURE IF EXISTS V20240807164914__Alter_governmentSponsorId_applicantPerson $$
CREATE PROCEDURE V20240807164914__Alter_governmentSponsorId_applicantPerson()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='applicant_person' AND column_name='governmentSponsorId')) THEN 
ALTER TABLE `applicant_person` 
ADD COLUMN `governmentSponsorId` BIGINT NULL;
END IF;

IF EXISTS (SELECT * FROM information_schema.referential_constraints where constraint_schema=database() and constraint_name='applicant_person_fk_governmentSponsorId' and table_name='applicant_person') THEN
ALTER TABLE `applicant_person` 
DROP FOREIGN KEY `applicant_person_fk_governmentSponsorId`;
END IF;

IF EXISTS ((SELECT * FROM information_schema.referential_constraints where constraint_schema=database() and constraint_name='ap_fk_governmentSponsorId' and table_name='applicant_person')) THEN 
ALTER TABLE `applicant_person` 
DROP FOREIGN KEY `ap_fk_governmentSponsorId`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.referential_constraints where constraint_schema=database() and constraint_name='ap_fk_governmentSponsorId')) THEN 
ALTER TABLE `applicant_person` 
ADD CONSTRAINT `ap_fk_governmentSponsorId`
FOREIGN KEY (`governmentSponsorId`)
REFERENCES `government_sponsor_csm` (`id`);
END IF;

END $$
CALL V20240807164914__Alter_governmentSponsorId_applicantPerson() $$
DROP PROCEDURE IF EXISTS V20240807164914__Alter_governmentSponsorId_applicantPerson $$
DELIMITER ;