DELIMITER $$
DROP PROCEDURE IF EXISTS V20240905182039__Create_ImportMapUnMapFilterTable $$
CREATE PROCEDURE V20240905182039__Create_ImportMapUnMapFilterTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='import_map_unmap_filter')) THEN 
CREATE TABLE `import_map_unmap_filter`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`jobId` BIGINT(20) NOT NULL,
	`assessmentSchemeType` VARCHAR(50) NOT NULL,
	`academicTermId` BIGINT(20) NULL DEFAULT NULL,
	`courseId` BIGINT(20) NULL DEFAULT NULL,
	`courseVariantIds` VARCHAR(50) NOT NULL,
	`assessmentSchemeId` BIGINT(20) NOT NULL,
	`assessmentSchemeLevelId` BIGINT(20) NULL DEFAULT NULL,
	`assessmentEventId` BIGINT(20) NOT NULL,
	`validationOn` VARCHAR(50) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	INDEX `map_unmap_idx1` (`jobId` ASC),
	INDEX `map_unmap_idx2` (`academicTermId` ASC),
	INDEX `map_unmap_idx3` (`courseId` ASC),
	INDEX `map_unmap_idx4` (`assessmentSchemeId` ASC),
	INDEX `map_unmap_idx5` (`assessmentSchemeLevelId` ASC),
	INDEX `map_unmap_idx6` (`assessmentEventId` ASC),
	INDEX `map_unmap_idx7` (`lastUpdatedBy` ASC),
	CONSTRAINT `fk_map_unmap_8` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
    );
END IF;  

END $$
CALL V20240905182039__Create_ImportMapUnMapFilterTable () $$ 
DROP PROCEDURE IF EXISTS V20240905182039__Create_ImportMapUnMapFilterTable $$ 
DELIMITER ;