DELIMITER $$
DROP PROCEDURE IF EXISTS V20240909172204__Create_PendingOfferLetterCSM $$
CREATE PROCEDURE V20240909172204__Create_PendingOfferLetterCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='pending_offer_letter_csm')) THEN 
CREATE TABLE `pending_offer_letter_csm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
    `sequenceNo` INT NOT NULL,
	`pendingOfferActive` BIT(1) NOT NULL DEFAULT b'1',
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `fk_pending_offer_letter_csm_lastUpdatedBy_idx` (`lastUpdatedBy`),
	CONSTRAINT `fk_pending_offer_letter_csm_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

	-- ------------------CSM DATA-------------------------------------------------
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'pending_offer_letter_csm')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'pending_offer_letter_csm','PENDING_OFFER_FLAG','Admissions','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;

IF EXISTS ((SELECT * FROM standard_master WHERE tableName = 'pending_offer_letter_csm')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'pending_offer_letter_csm');

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`,`diaplayOrder`, `whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`, `whetherReadOnly`, `wheherNullable`,`lastUpdatedBy`, `lastUpdate`)
VALUES ('sequenceNo', 'SEQUENCE_NO', @standardMasterId,'Number',NULL,3,0,NULL,NULL,NULL,0,0,0,1,now());

INSERT INTO standard_master_items (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('pendingOfferActive','ACTIVE_STATUS',@standardMasterId,'Boolean',NULL,4,0,NULL,NULL,NULL,0,0,0,1,now());

END IF; 

-- ------------------TRANSLATION-------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' AND keyName = 'PENDING_OFFER_FLAG')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'PENDING_OFFER_FLAG', 'Pending Offer Flag', 'Pending Offer Flag','Hangende aanbodvlag','Cờ ưu đãi đang chờ xử lý',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' AND keyName = 'PENDING_OFFER_FLAG')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'PENDING_OFFER_FLAG', 'Pending Offer Flag', 'Pending Offer Flag','Hangende aanbodvlag','Cờ ưu đãi đang chờ xử lý',now(),1);
END IF;

END $$
CALL V20240909172204__Create_PendingOfferLetterCSM () $$ 
DROP PROCEDURE IF EXISTS V20240909172204__Create_PendingOfferLetterCSM $$ 
DELIMITER ;