DELIMITER $$
DROP PROCEDURE IF EXISTS V20240916120005__Insert_LegacyDataBuzzCampaignCode $$
CREATE PROCEDURE V20240916120005__Insert_LegacyDataBuzzCampaignCode()
BEGIN
declare row_counter bigint;
declare rowId bigint;
declare rowNumber bigint;
declare done int default 0;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='campaign_new' AND column_name='code')) THEN 

create table campaign_new_backup_before_proc_Execution select id,code from campaign_new;
create table temp_campaing_new_with_rn SELECT id, createdOn, ROW_NUMBER() OVER (ORDER BY createdOn, id) AS rn FROM campaign_new where code is null;

BLOCK1: begin

declare codeupdate_cursor cursor for select rn,id from temp_campaing_new_with_rn order by rn;
declare continue handler for not found set done=1;

open codeupdate_cursor;

loop1:loop

fetch codeupdate_cursor into rowNumber,rowId;

if done=1 then 
leave loop1;
end if;

SET SQL_SAFE_UPDATES=0;

if(rowNumber<10) then
set @finalNewCode=concat('CC00000',rowNumber);
update campaign_new set code=@finalNewCode where id=rowId;

ELSEIF (rowNumber>9 and rowNumber<100)
then 
set @finalNewCode=concat('CC0000',rowNumber);
update campaign_new set code=@finalNewCode where id=rowId;

ELSEIF (rowNumber>99 and rowNumber<1000)
then
set @finalNewCode=concat('CC000',rowNumber);
update campaign_new set code=@finalNewCode where id=rowId;

ELSEIF (rowNumber>999 and rowNumber<10000) 
then
set @finalNewCode=concat('CC00',rowNumber);
update campaign_new set code=@finalNewCode where id=rowId;

ELSEIF (rowNumber>9999 and rowNumber<100000)
then
set @finalNewCode=concat('CC0',rowNumber);
update campaign_new set code=@finalNewCode where id=rowId;

ELSEIF (rowNumber>99999 and rowNumber<1000000)
then
set @finalNewCode=concat('CC',rowNumber);

update campaign_new set code=@finalNewCode where id=rowId;
else
leave loop1;

end if;


SET SQL_SAFE_UPDATES=1;



END loop loop1;
END BLOCK1;

drop table temp_campaing_new_with_rn;

END IF; 

END $$
CALL V20240916120005__Insert_LegacyDataBuzzCampaignCode() $$
DROP PROCEDURE IF EXISTS V20240916120005__Insert_LegacyDataBuzzCampaignCode $$
DELIMITER ;