DELIMITER $$
DROP PROCEDURE IF EXISTS V20240920160201__Update_REG_POST_AUTHORIZATION $$
CREATE PROCEDURE V20240920160201__Update_REG_POST_AUTHORIZATION()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (SELECT * FROM dtprovider where dataProviderName="REGISTRATION_POST_AUTHORIZATION_RCPNT") THEN 


SET @rcpntId = (SELECT id FROM dtprovider where dataProviderName="REGISTRATION_POST_AUTHORIZATION_RCPNT");

UPDATE sql_dtprovider
set sqlQuery =
"SELECT DISTINCT
    T2.id AS ID,
    T17.printName as USERNAME,
    T18.printName AS STUDENT_PRINT_NAME,
    T18.firstName AS FIRST_NAME,
    T18.middleName AS MIDDLE_NAME,
    T18.lastName AS LAST_NAME,
    T18.emailId AS EMAIL_ID,
    T18.alternateEmailId as ALTERNATE_EMAIL_ID,
    T18.mobileNumber AS MOBILE_NO,
    T18.mobileCountryCode AS MOBILE_CODE,
    CONVERT(FROM_BASE64(T17.passwordBase64) USING utf8) AS PASSWORD,
    T5.programNameToBePrint AS PROGRAM_NAME,
    T4.printName AS INTAKE_NAME,
    T6.printName AS PERIOD_NAME,
    T17.code AS STUDENT_ID, 
    T15.itemValue AS ACADEMIC_TERM, 
    T16.itemValue AS INTAKE_YEAR,
    T7.academyName AS ACADEMY_NAME,
    T7.locationName AS LOCATION_NAME,
    T7.displayName AS ACADEMY_LOCATION,
    T14.seatName as SEAT_TYPE,
    CONCAT(T9.phoneCountryCode,'-',T9.phoneAreaCode,'-',T9.phoneNo) AS CAMPUS_PHONE_NO,
    T9.primaryeEmailId AS CAMPUS_EMAILID,
    T9.websiteURL AS CAMPUS_WEBSITE_URL,
   T18.externalSysRefOne AS SU_NUMBER,
    date(now()) as CURRENT_DATE_,
    (CASE
        WHEN
            T7.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T7.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
    T24.feeAmount AS ADDITIONAL_FEES
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    academy_location T7 on T7.id = T5.academyLocationId
        LEFT OUTER JOIN
    academy_location_addresses ala on ala.academyLocationId = T7.id
        LEFT OUTER JOIN
    address T9 ON T9.id = ala.addressId 
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT OUTER JOIN
    prog_batch_seat_config T13 on T13.id = T1.progBatchSeatConfigId
        LEFT OUTER JOIN
    fee_plan_acad_locations T20 on T13.id = T20.progBatchSeatConfigId
        LEFT OUTER JOIN
    fee_plan T21 on T20.feePlanId = T21.id
         LEFT OUTER JOIN
    fee_plan_rules T22 on  T22.feePlanId = T21.id
        LEFT OUTER JOIN
   fee_plan_rule_stage T23 on T23.feePlanRuleId = T22.id
        LEFT OUTER JOIN
   fee_stage_head_config T24 on  T24.feePlanRuleStageId = T23.id    
        LEFT OUTER JOIN
    seat_types T14 on T14.id = T13.seatTypeId
        LEFT OUTER JOIN
    academic_term T15 on T15.id = T6.academicTermId
        LEFT OUTER JOIN
    intake_year T16 on T16.id = T4.intakeYearId
        LEFT OUTER JOIN
    users T17 on T17.id = T3.userId
        LEFT OUTER JOIN
    persons T18 on T18.id = T3.personId
     LEFT OUTER JOIN    
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null
AND T2.id in (namedParams)  AND T23.whetherGeneratebillsForStdLateAdm = true
group by T3.userId"
, jsonString = '{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "campusPhoneNo",
            "resultKey": "CAMPUS_PHONE_NO",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "campusEmailId",
            "resultKey": "CAMPUS_EMAILID",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "campusWebsiteUrl",
            "resultKey": "CAMPUS_WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "seatName",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "printName",
            "resultKey": "USERNAME",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "printName",
            "resultKey": "INTAKE_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "printName",
            "resultKey": "PERIOD_NAME",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "Password",
            "resultKey": "PASSWORD",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "itemValue",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "itemValue",
            "resultKey": "INTAKE_YEAR",
            "displayCode": "",
            "displayOrder": 19
        },
{
            "id": 21,
            "value": "externalSysRefOne",
            "resultKey": "SU_NUMBER",
            "displayCode": "",
            "displayOrder": 20
        },
{
            "id": 22,
            "value": "Date",
            "resultKey": "CURRENT_DATE_",
            "displayCode": "",
            "displayOrder": 21
        },
{
            "id": 23,
            "value": "additionalFees",
            "resultKey": "ADDITIONAL_FEES",
            "displayCode": "",
            "displayOrder": 22
        }
    ]}' WHERE dataProviderId = @rcpntId;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240920160201__Update_REG_POST_AUTHORIZATION () $$
DROP PROCEDURE IF EXISTS V20240920160201__Update_REG_POST_AUTHORIZATION $$
DELIMITER ;