DROP PROCEDURE IF EXISTS rpt_admissionSummaryApprovalDate;
DELIMITER $$
CREATE DEFINER=`ss_root`@`%` PROCEDURE `rpt_admissionSummaryApprovalDate`(academyLocation text, intakeYear int(10), StartDate date, EndDate date, ProgramCategory varchar(5), ProgramGroup  varchar(5), seatType text)
BEGIN
declare StartDateNull, EndDateNull, ProgramCategoryNull, ProgramGroupNull, seatTypeNull boolean;

   SET SQL_SAFE_UPDATES = 0;
   
   call str_to_row (academyLocation);
   call str_to_row_seattype (seatType);
   
   if StartDate is null then
  set StartDateNull = 1;
   else set StartDateNull = 0;
   end if;
   if EndDate is null then
  set EndDateNull = 1;
   else set EndDateNull = 0;
   end if;
   if ProgramCategory is null then
  set ProgramCategoryNull = 1;
   else set ProgramCategoryNull = 0;
   end if;
   if ProgramGroup is null then
  set ProgramGroupNull = 1;
   else set ProgramGroupNull = 0;
   end if;
   if (seatType is null or seatType='')then
  set seatTypeNull = 1;
   else set seatTypeNull = 0;
   end if;

   drop table if exists tbl_admissionSummaryApprovalDate;
   create table tbl_admissionSummaryApprovalDate(Brand_Campus text, Brand_Campus_ID long, programId long, grade varchar(500)
   , Total_Admission int default 0, Weekly_movement_Admission int default 0, conversion_perc_assessment double default 0
   , Target_for_admission int default 0 , Perc_Target_Admission double default 0
   , YOY_Variance_for_total_Admissions_target double default 0,prev_yr_tot_admission int default 0, totalSuccessfulApplications int default 0,programSequence int  default 0)
   comment 'Temporary Table for Admission Summary Report';

   insert into tbl_admissionSummaryApprovalDate(Brand_Campus, Brand_Campus_ID, programId, grade,programSequence)
   select concat(al.academyName, '-', al.locationName), al.id, p.id, p.programNameToBePrint,p.programSequence
  from academy_location al join programs p on al.id = p.academyLocationId and p.status = 'O'
  join batches as b on p.id = b.programId
    join prog_batch_seat_config absc on absc.programBatchId=b.id
  where p.programClosureDate is null
and al.id in (select s from tbl_str_to_row) and b.intakeYearId = intakeYear
  and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
    and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
  group by al.id, p.id;

update tbl_admissionSummaryApprovalDate as t, (select count(distinct a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, aad.admissionApprovedOn, b.startDate, b.tillDate
  from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id 
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
join programs p on p.id = b.programId
  where a.academyLocationId in (select s from tbl_str_to_row)
  and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
  and (date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
  group by a.academyLocationId, p.id) as q
  set t.Total_Admission = q.tot_admissions
  where t.Brand_Campus_ID = q.academyLocationId and t.programId = q.grade_id;



   update tbl_admissionSummaryApprovalDate as t,
(select a.academyLocationId, a.programId, count(distinct a.id) as tot_weekly_admissions, calendars.weekStart

from admission as a join academy_location_purpose alp on a.academyLocationId = alp.academyLocationId
join calendars on alp.calendarId = calendars.id
join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches as b on a.batchId = b.id and b.intakeYearId = intakeYear
join programs as p on p.id = b.programId
where date(aad.admissionApprovedOn) between (date_sub(current_date(), interval WEEKDAY(current_date()) - (case when weekStart = 'MONDAY' then 0
when weekStart = 'TUESDAY' then 1 when weekStart = 'WEDNESDAY' then 2
when weekStart = 'THURSDAY' then 3 when weekStart = 'FRIDAY' then 4
when weekStart = 'SATURDAY' then 5 end) day)) and current_date()
and a.academyLocationId in (select s from tbl_str_to_row)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
and (date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by a.academyLocationId, p.id) as q
set t.Weekly_movement_Admission = q.tot_weekly_admissions
where t.Brand_Campus_ID = q.academyLocationId and t.programId = q.programId;

update tbl_admissionSummaryApprovalDate as t, (select adm.tot_admissions, adm.batchId, adm.grade_id, adm.academyLocationId, apl.Total_SUCCESSFUL_Admission as totalSuccessfulApplications
   , (adm.tot_admissions / ifnull(apl.Total_SUCCESSFUL_Admission, 1) * 100) as conv_perc
   from
   (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, aad.admissionApprovedOn, b.startDate, b.tillDate
from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
join programs p on p.id = b.programId
  where a.academyLocationId in (select s from tbl_str_to_row)
and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
and (date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
  and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
            and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
  group by a.academyLocationId, p.id) as adm join
  (Select al.id, p.id as grade_id, count(distinct a.id) as Total_SUCCESSFUL_Admission
  from application a right join application_program ap on a.id=ap.applicationId
  left join programs p on p.id = ap.programId
  left join academy_location al on al.id = ap.academyLocationId 
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id 
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
  where a.currentStatus in ('APPROVED','ADMISSION_GRANTED','DIRECT_SUBMISSION_TOKEN_GENERATED','SOLD,FORM_SALE_TOKEN_GENERATED','DIRECT_ADMISSION')
  and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
  and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id) apl
  on adm.academyLocationId = apl.id and adm.grade_id = apl.grade_id) as d
  set t.conversion_perc_assessment = d.conv_perc
    , t.totalSuccessfulApplications = d.totalSuccessfulApplications
  where t.Brand_Campus_ID = d.academyLocationId and t.programId = d.grade_id;


update tbl_admissionSummaryApprovalDate as t, (
select p.academyLocationId, b.intakeYearId, p.id programId, b.id batchId, (b.seatCapacity - count(distinct a.Id)) as target_for_admission
  from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id 
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
join programs p on p.id = b.programId
  where a.academyLocationId in (select s from tbl_str_to_row)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
and (date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
and a.status in ('ADMISSION_CONFIRMED', 'ADMITTED_PROVISIONALLY')
group by p.id, b.id) as q
  set t.Target_for_admission = q.target_for_admission
  where t.Brand_Campus_ID = q.academyLocationId and t.programId = q.programId;

   
   update tbl_admissionSummaryApprovalDate as t
   set t.Perc_Target_Admission = ifnull(t.Total_Admission / NULLIF(Target_for_admission,0) * 100,0);

   
   update tbl_admissionSummaryApprovalDate as t,
   (select curr_yr_admission.tot_admissions as cur_tot_admissions, curr_yr_admission.batchId, curr_yr_admission.grade_id, curr_yr_admission.academyLocationId, prev_yr_admission.tot_admissions as prev_tot_admissions
   , ifnull(((curr_yr_admission.tot_admissions - prev_yr_admission.tot_admissions)/NULLIF(prev_yr_admission.tot_admissions,0) * 100),0) as YOY_Variance_for_total_Admissions_target
   from
   (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, aad.admissionApprovedOn
  from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id 
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches b on b.id = absc.programBatchId and b.intakeYearId = (select id from intake_year
where itemValue = (select itemValue - 1 from intake_year where id = intakeYear limit 1) limit 1)
join programs p on p.id = b.programId
  where a.academyLocationId in (select s from tbl_str_to_row)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
and (date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
  group by a.academyLocationId, p.id) as prev_yr_admission
   join (select count(a.id) as tot_admissions, a.batchId, p.id as grade_id, a.academyLocationId, aad.admissionApprovedOn
  from admission as a join prog_batch_seat_config absc on a.programBatchSeatConfigId = absc.id 
join application_admission_detail as aad on a.applicationProgramId = aad.applicationProgramId
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
join programs p on p.id = b.programId
  where a.academyLocationId in (select s from tbl_str_to_row)
 and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
  and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (date(aad.admissionApprovedOn) >= StartDate or 1 = StartDateNull)
and (date(aad.admissionApprovedOn)<= EndDate or 1 = EndDateNull)
        and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
  group by a.academyLocationId, p.id) as curr_yr_admission
   on prev_yr_admission.academyLocationId = curr_yr_admission.academyLocationId
   and prev_yr_admission.grade_id = curr_yr_admission.grade_id) as d
   set t.YOY_Variance_for_total_Admissions_target = d.YOY_Variance_for_total_Admissions_target
    ,t.prev_yr_tot_admission=d.prev_tot_admissions
   where t.Brand_Campus_ID = d.academyLocationId and t.programId = d.grade_id;
   

   select Brand_Campus_ID as academyLocationId, Brand_Campus as academyLocationName
  , programId, grade as programName,(case when Total_Admission is null then 0 else Total_Admission end) as totalAdmission
  ,(case when Weekly_movement_Admission is null then 0 else Weekly_movement_Admission end) as WMofAdmission,(case when conversion_perc_assessment is null then 0 else conversion_perc_assessment end) as ConPercFromAs
  ,(case when Target_for_admission is null then 0 else Target_for_admission end) as targetForAdmission,(case when Perc_Target_Admission is null then 0 else Perc_Target_Admission end) as perOfTargetForAdmission
  ,(case when YOY_Variance_for_total_Admissions_target is null then 0 else YOY_Variance_for_total_Admissions_target end) as yoyTotalAdmission,(case when prev_yr_tot_admission is null then 0 else prev_yr_tot_admission end) as prevTotalAdmission,(case when totalSuccessfulApplications is null then 0 else totalSuccessfulApplications end) totalSuccessfulApplications,(case when programSequence is null then 0 else programSequence end) programSequence
   from tbl_admissionSummaryApprovalDate order by Brand_Campus,programSequence;
   
END $$
DELIMITER ;
