DELIMITER $$
DROP PROCEDURE IF EXISTS d2l7Users $$
CREATE PROCEDURE d2l7Users()
BEGIN
SELECT
'type', 'action', 'username', 'org_defined_id', 'first_name', 'last_name', 'password', 'is_active','role_name', 'email', 'relationships', 'pref_first_name', 'pref_last_name'
 UNION
SELECT
'user', 'UPDATE', users.code, users.id, users.firstName, users.lastName, '',if(users.status=b'1',1,0), user_groups.userGroupName,CONCAT(users.code,'@yopmail.com'), '', users.firstName, ''
from student_course_enrollment as enroll
join admission on enroll.admissionId=admission.id
join users on admission.studentId=users.id
join user_groups on users.userGroupId=user_groups.id and user_groups.userGroupName in('Student')
join sections on enroll.sectionId = sections.id
join prog_batch_period_config as period on enroll.programBatchPeriodConfigId= period.id
JOIN academic_term ON period.academicTermId=academic_term.id AND academic_term.whetherCurrentAcademicTerm=true
join batches on period.programBatchId=batches.id
WHERE enroll.exitDate IS NULL AND admission.activeStatus=TRUE AND users.status=TRUE and users.status=b'1'
UNION
SELECT
'user', 'UPDATE', users.code, users.id, users.firstName, users.lastName, '',if(users.status=b'1',1,0), 'Teacher',CONCAT(users.code,'@yopmail.com'), '', users.firstName, ''
from prog_batch_course_faculty as pbFaculty
join users on pbFaculty.facultyId=users.id
join user_groups on users.userGroupId=user_groups.id and user_groups.userGroupName in('Faculty')
join program_batch_course_param as param on pbFaculty.progBatchCourseParamId=param.id
join prog_batch_period_config as period on param.progBatchPeriodConfigId= period.id
join batches on period.programBatchId=batches.id
JOIN academic_term ON period.academicTermId=academic_term.id AND academic_term.whetherCurrentAcademicTerm=true
join sections on param.sectionId = sections.id
WHERE users.status=TRUE and users.status=b'1';
END $$
DELIMITER ;