DELIMITER $$
DROP PROCEDURE IF EXISTS V20241204165913__Alter_GoogleAddressKeyConf $$
CREATE PROCEDURE V20241204165913__Alter_GoogleAddressKeyConf()
BEGIN

IF NOT EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and table_name='google_address_keyconfiguration' and index_name='fk_academylocationid_idx') then
ALTER TABLE google_address_keyconfiguration ADD INDEX fk_academylocationid_idx (academyLocationId);
END IF;

IF EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_academylocationid_idx' AND table_name='google_address_keyconfiguration') then
ALTER TABLE google_address_keyconfiguration ADD CONSTRAINT fk_academylocationid_idx
  FOREIGN KEY (academyLocationId)
  REFERENCES academy_location (id)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
END IF;

END $$
CALL V20241204165913__Alter_GoogleAddressKeyConf() $$
DROP PROCEDURE IF EXISTS V20241204165913__Alter_GoogleAddressKeyConf $$
DELIMITER ;