DELIMITER $$
DROP PROCEDURE IF EXISTS V20241217115147__Update_ServiceRequestComment $$
CREATE PROCEDURE V20241217115147__Update_ServiceRequestComment()
BEGIN
SET SQL_SAFE_UPDATES=0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QUICK_COMMENT_FOR_REQUESTOR_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.emailId AS EMAIL_ID,
    T2.documentName AS DOCUMENT_NAME,
    T1.comments AS COMMENTS,
    T3.requestId AS SERVICE_REQUEST_NO,
    T5.code AS STUDENT_NO,
    T6.programName AS PROGRAM,
    T7.batchName AS BATCH,
    T10.academyName AS ACADEMY_NAME,
    T10.locationName AS LOCATION_NAME,
    T10.displayName AS ACADEMY_NAME_LOCATION,
     (CASE
        WHEN
            T10.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T10.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T10.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T10.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM
    quick_comment T1
LEFT OUTER JOIN
    documents T2 ON T1.documentId = T2.id
LEFT OUTER JOIN
    service_requests T3 ON T1.serviceRequestId = T3.id
LEFT OUTER JOIN
    service_request_settings T9 ON T3.serviceRequestSettingId = T9.id
LEFT OUTER JOIN
    academy_location T10 ON T9.academyLocationId = T10.id
LEFT OUTER JOIN
    programs T6 ON T3.currentProgram = T6.id
LEFT OUTER JOIN
    batches T7 ON T3.batchId = T7.id
LEFT OUTER JOIN
    users T5 ON T5.id = T3.requester
LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE 
     T1.id IN (namedParams)"
WHERE `dataProviderId`=@dtproviderId; 
 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QUICK_COMMENT_FOR_REQUESTOR_DL');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT DISTINCT T1.id AS USER_ID FROM quick_comment T1 WHERE T1.id IN (namedParams)" WHERE `dataProviderId`=@dtproviderId; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241217115147__Update_ServiceRequestComment () $$
DROP PROCEDURE IF EXISTS V20241217115147__Update_ServiceRequestComment $$
DELIMITER ;