CREATE OR REPLACE  VIEW `analytics_alumni_directory_view` AS
SELECT DISTINCT `u`.`alumniCode` AS `SignUpCode`,`ap`.`firstName` AS `FirstName`,`ap`.`middleName` AS `MiddleName`,`ap`.`lastName` AS `LastName`,`ap`.`id` AS `Alumni_person_id`,`ap`.`gender` AS `Gender`,`al`.`academyCode` AS `academyCode`,`al`.`locationCode` AS `locationCode`,`ap`.`birthDate` AS `Dob`,`ap`.`emailId` AS `Email`,`ap`.`mobileNumber` AS `Mobile Number`,`ap`.`phoneCountryCode` AS `phoneCountryCode`,`ap`.`passoutYear` AS `PassOutYear`,`ap`.`admissionCode` AS `Admission Code`,`ap`.`studentCode` AS `Student Code`,`ap`.`otherProgramName` AS `Other Program Name`,`ap`.`otherBatchName` AS `Other Batch Name`,`ap`.`status` AS `Alumni Status`,`ap`.`reason` AS `Rejection Reason`,`u`.`createdDate` AS `User Created Date`,`al`.`displayName` AS `Academy Location`,`p`.`programName` AS `Program Name`,`p`.`programCode` AS `Program Code`,`pc`.`categoryName` AS `Program Category`,`pg`.`groupName` AS `Program Group`,`d`.`deptName` AS `Department Name`,`d`.`shortCode` AS `Department Code`,`b`.`batchName` AS `Batch Name`, CONCAT(IFNULL(`ap`.`firstName`,''),' ', IFNULL(`ap`.`middleName`,''),' ', IFNULL(`ap`.`lastName`,'')) AS `fullName`,`aa`.`addressType` AS `Address Type`,`aa`.`addressLine1` AS `Address Line 1`,`aa`.`addressLine2` AS `Address Line 2`,`c`.`cityName` AS `City`,`cou`.`countryName` AS `Country`,`aa`.`postalCode` AS `Postal Code`,(DATE_FORMAT(FROM_DAYS((TO_DAYS(curdate()) - TO_DAYS(`ap`.`birthDate`))),'%Y') + 0) AS `age`,`iy`.`itemValue` AS `Intake Year`,`u`.`whetherActive` AS `Active Status`,`u`.`id` AS `Alumni_user_Primary ID`,`api`.`occupation` AS `Occupation`,`api`.`organization` AS `Organization`,`api`.`designation` AS `Designation`,`api`.`officialEmailId` AS `Official Email Id`,`api`.`officialContactNumber` AS `Official Contact Number`,`api`.`officialWebsiteLink` AS `Website Link`,`api`.`linkedInLink` AS `LinkedIn`,`api`.`twitterLink` AS `Twitter Link`,`ap`.`whetherDeleted` AS `IsAluminiDeleted`
FROM (((((((((((((`alumni_persons` `ap`
LEFT JOIN `alumni_users` `u` ON((`ap`.`alumniUserId` = `u`.`id`)))
LEFT JOIN `academy_location` `al` ON((`ap`.`academyLocationId` = `al`.`id`)))
LEFT JOIN `batches` `b` ON((`ap`.`batchId` = `b`.`id`)))
LEFT JOIN `programs` `p` ON((`b`.`programId` = `p`.`id`)))
LEFT JOIN `program_group` `pg` ON((`pg`.`id` = `p`.`programGroupId`)))
LEFT JOIN `program_category` `pc` ON((`pc`.`id` = `p`.`programCategoryId`)))
LEFT JOIN `department` `d` ON((`d`.`id` = `p`.`programDepartmentId`)))
LEFT JOIN `alumni_address` `aa` ON(((`aa`.`alumniPersonId` = `ap`.`id`) AND (`aa`.`addressType` = 'PROFESSIONAL'))))
LEFT JOIN `city` `c` ON((`c`.`id` = `aa`.`cityId`)))
LEFT JOIN `country` `cou` ON((`cou`.`id` = `c`.`countryId`)))
LEFT JOIN `intake_year` `iy` ON((`iy`.`id` = `b`.`intakeYearId`)))
LEFT JOIN `alumni_professional_information` `api` ON((`api`.`alumniPersonId` = `ap`.`id`)))
JOIN `salutations` ON((`ap`.`salutationId` = `salutations`.`id`))) ;