DELIMITER $$
DROP PROCEDURE IF EXISTS V20241230123833__Create_NonConcessionAllocationTable $$
CREATE PROCEDURE V20241230123833__Create_NonConcessionAllocationTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='non_concession_allocation')) THEN 
		
	CREATE TABLE `non_concession_allocation`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`courseId` BIGINT(20) NOT NULL,
	`evalSeqDetailId` BIGINT(20) NOT NULL,
	`courseEnrolmentCount` BIGINT NULL DEFAULT NULL,
	`internalResourceId` BIGINT(20) NULL DEFAULT NULL,
	`studntRoomAllocation` BIGINT(20) NULL DEFAULT NULL,
	`firstInvigilatorId` BIGINT(20) NULL DEFAULT NULL,
	`secondInvigilatorId` BIGINT(20) NULL DEFAULT NULL,
	`thirdInvigilatorId` BIGINT(20) NULL DEFAULT NULL,
	`fourthInvigilatorId` BIGINT(20) NULL DEFAULT NULL,
	`remainingCapacity` BIGINT NULL DEFAULT NULL,
	`date` DATE NULL DEFAULT NULL,
	`time` TIME NULL DEFAULT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	PRIMARY KEY (`id`), 
	CONSTRAINT `non_concession_allocation_courseId_FK` FOREIGN KEY (`courseId`) REFERENCES `courses`(`id`),
	CONSTRAINT `non_concession_allocation_evalSeqDetailId_FK` FOREIGN KEY (`evalSeqDetailId`) REFERENCES `eval_seq_detail`(`id`),
	CONSTRAINT `non_concession_allocation_intResId_FK` FOREIGN KEY (`internalResourceId`) REFERENCES `resources`(`id`),
	CONSTRAINT `non_concession_allocation_firstInvgltr_FK` FOREIGN KEY (`firstInvigilatorId`) REFERENCES `exam_external_invigilator_master_data`(`id`),
	CONSTRAINT `non_concession_allocation_secondInvgltr_FK` FOREIGN KEY (`secondInvigilatorId`) REFERENCES `exam_external_invigilator_master_data`(`id`),
	CONSTRAINT `non_concession_allocation_thirdInvgltr_FK` FOREIGN KEY (`thirdInvigilatorId`) REFERENCES `exam_external_invigilator_master_data`(`id`),
	CONSTRAINT `non_concession_allocation_fourthInvgltr_FK` FOREIGN KEY (`fourthInvigilatorId`) REFERENCES `exam_external_invigilator_master_data`(`id`),
	CONSTRAINT `non_concession_allocation_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) 
	ENGINE=INNODB; 
	
END IF; 

END $$
CALL V20241230123833__Create_NonConcessionAllocationTable () $$ 
DROP PROCEDURE IF EXISTS V20241230123833__Create_NonConcessionAllocationTable $$ 
DELIMITER ;