DELIMITER $$
DROP PROCEDURE IF EXISTS V20250124123201__Alter_lessonPlanAddDublin $$
CREATE PROCEDURE V20250124123201__Alter_lessonPlanAddDublin()
BEGIN

IF NOT EXISTS ((SELECT * FROM   INFORMATION_SCHEMA.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'lesson_plan' AND COLUMN_NAME = 'programId')) THEN 
ALTER TABLE `lesson_plan` 
ADD COLUMN `programId` BIGINT NULL DEFAULT NULL;
 END IF;
 
IF NOT EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and table_name='lesson_plan' and index_name='Refprogram_idx') then
ALTER TABLE `lesson_plan` ADD INDEX `Refprogram_idx` (`programId` ASC) ;
 END IF;
 
 IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='Ref_lesson_plan_program' AND table_name='lesson_plan') then
ALTER TABLE `lesson_plan`
ADD CONSTRAINT `Ref_lesson_plan_program`
  FOREIGN KEY (`programId`)
  REFERENCES `programs` (`id`);
  END IF;
  
 IF NOT EXISTS ((SELECT * FROM   INFORMATION_SCHEMA.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'lesson_plan' AND COLUMN_NAME = 'generalEducationCategoryId')) THEN 
ALTER TABLE `lesson_plan`
ADD COLUMN `generalEducationCategoryId` BIGINT NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and table_name='lesson_plan' and index_name='RefgeneralEducationCategory_idx') then
ALTER TABLE `lesson_plan` ADD INDEX `RefgeneralEducationCategory_idx` (`generalEducationCategoryId` ASC);
END IF;

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='Ref_lesson_plan_generalEducationCategory' AND table_name='lesson_plan') then
ALTER TABLE `lesson_plan`
ADD CONSTRAINT `Ref_lesson_plan_generalEducationCategory`
  FOREIGN KEY (`generalEducationCategoryId`)
  REFERENCES `general_education_category_csm` (`id`);
  END IF;

END $$
CALL V20250124123201__Alter_lessonPlanAddDublin() $$
DROP PROCEDURE IF EXISTS V20250124123201__Alter_lessonPlanAddDublin $$
DELIMITER ;