DELIMITER $$
DROP PROCEDURE IF EXISTS V20250221114923__Insert_terminationacademylocation $$
CREATE PROCEDURE V20250221114923__Insert_terminationacademylocation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='termination_academy_location')) THEN 
CREATE TABLE `termination_academy_location` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `terminationReasonId` BIGINT(20) NOT NULL,
  `academyLocationId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `FK_termination_reaon_idx` (`terminationReasonId` ASC) ,
  INDEX `FK_termination_reason_academy_location_idx` (`academyLocationId` ASC) ,
  INDEX `FK_termination_lastUpdatedBy_idx` (`lastUpdatedBy` ASC) ,
  CONSTRAINT `FK_termination_reaon`
    FOREIGN KEY (`terminationReasonId`)
    REFERENCES `termination_reasons` (`id`),
  CONSTRAINT `FK_termination_reason_academy_location`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`),
  CONSTRAINT `FK_termination_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`));
END IF; 


END $$
CALL V20250221114923__Insert_terminationacademylocation() $$
DROP PROCEDURE IF EXISTS V20250221114923__Insert_terminationacademylocation $$
DELIMITER ;