DELIMITER $$
DROP PROCEDURE IF EXISTS V20250317140935__Create_UWC_CCE_Transcript_Report $$
CREATE PROCEDURE V20250317140935__Create_UWC_CCE_Transcript_Report()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet'); 

IF NOT EXISTS (select * from report_template where templateCode='UWC_CCE_TRANSCRIPT') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'UWC_CCE_TRANSCRIPT', 'UWC CCE Transcript', 'UWC_CCE_TRANSCRIPT.png', 'CommonReport_UWC_CCE_TRANSCRIPT.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'UWC_CCE_TRANSCRIPT.jasper', 'AcademiaLogo.png');
END IF; 

set @tempKeySurname = (select max(id) from report_template 
where templateCode ='UWC_CCE_TRANSCRIPT' and templateName='UWC CCE Transcript');


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_ACADEMIC_TRANSCRIPT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_ACADEMIC_TRANSCRIPT', 'ACADEMIC TRANSCRIPT', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_ACADEMIC_ADMINISTRATION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_ACADEMIC_ADMINISTRATION', 'ACADEMIC ADMINISTRATION – REGISTRAR’S DIVISION', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_THE_UNIVERSITY1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_THE_UNIVERSITY1', 'The University of the Western Cape is a Public Higher Education institution established and regulated by the Higher Education Act, No. 101 of 1997 (Republic of South Africa), with the language of instruction being English.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_THE_UNIVERSITY2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_THE_UNIVERSITY2', 'The University is duly accredited by the Council on Higher Education and its degrees and diplomas are registered on the National Qualifications Framework in terms of the South African Qualifications Authority Act, No. 58 of 1995.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CERTIFY1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CERTIFY1', 'This is to certify that the student', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CERTIFY2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CERTIFY2', 'was/is registered at this University for the qualification/s listed below. The programme of study, assessment results and credits obtained are detailed and an overall summary is provided.', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PARTICIPANT_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PARTICIPANT_NAME', 'Participant Name', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PARTICIPANT_NUMBER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PARTICIPANT_NUMBER', 'Participant Number', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_IDENTITY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_IDENTITY', 'Identity Number/Passport Number', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_BIRTH_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_BIRTH_DATE', 'Date of Birth', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_REG_YEAR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_REG_YEAR', 'Current/Last Registration Year', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_MEDIUM')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_MEDIUM1', 'MEDIUM/LANGUAGE OF INSTRUCTION', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_ENGLISH')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_ENGLISH', 'ENGLISH', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_MEDIUM')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_MEDIUM2', '(all learning, teaching and assessments are conducted in English)', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PARTICIPANT_CONDUCT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PARTICIPANT_CONDUCT1', 'Participant Conduct: SATISFACTORY', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PARTICIPANT_CONDUCT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PARTICIPANT_CONDUCT2', '(behaviour during the period of study, related to student discipline). Student qualifies for a certificate of good conduct for the duration of the studies. Records reflect no negative report on conduct .', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_YOURS_SINCERELY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_YOURS_SINCERELY', 'Yours sincerely', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_REGISTRAR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_REGISTRAR', 'REGISTRAR', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_ACADEMIC_ADMINISTRATION1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_ACADEMIC_ADMINISTRATION1', 'ACADEMIC ADMINISTRATION', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_THIS_DOCUMENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_THIS_DOCUMENT', 'This document contains a qualified electronic signature and date stamp. To verify this document contact the Graduation Office of the University of the Western Cape at helpdesk@uwc.ac.za.', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_NOTE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_NOTE', 'Please note that the Registrar’s signature and University stamp are electronically embedded.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PLEASE_NOTE1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PLEASE_NOTE1', 'Please note that in certain instances results are provisional and are subject to change. Although the University endeavours at all times to publish results accurately, errors may occur.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PLEASE_NOTE2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PLEASE_NOTE2', 'An error does not give the candidate the right to a pass mark or the award of a certificate, diploma or degree.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PLEASE_NOTE3')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PLEASE_NOTE3', 'Any alteration to this document in any manner or form is a contravention of the University’s rules, regulations, policies, procedures and standing orders and may constitute fraud.', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATE_ISSUED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATE_ISSUED', 'Date Issued', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PARTICIPANT_NAME1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PARTICIPANT_NAME1', 'Participant Name', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PARTICIPANT_NUMBER1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PARTICIPANT_NUMBER1', 'Participant Number', '1', NOW());
END IF;





IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_ACADEMIC_PROGRAMME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_ACADEMIC_PROGRAMME', 'ACADEMIC PROGRAMME RECORD', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PROGRAMME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PROGRAMME', 'Programme', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPE', 'Qualification Type', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_STUDY_TYPE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_STUDY_TYPE', 'Study Type', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_COURSE_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_COURSE_NAME', 'Course name', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CREDITS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CREDITS', 'Credits', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_NQF')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_NQF', 'NQF', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_RESULT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_RESULT', 'Result%', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_REMARK')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_REMARK', 'Remark', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME', 'Outcome', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CERTIFICATE_KEY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CERTIFICATE_KEY', 'Certificate Key', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_SYMBOLS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_SYMBOLS', 'SYMBOLS', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_SYMBOLS_DESCRIPTION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_SYMBOLS_DESCRIPTION', 'A: 75-100 % (Pass), B: 70-74 % (Pass), C: 60-69 % (Pass), D: 50-59 % (Pass), E: 45-49 % (Fail), F: 40-44 % (Fail), G: 0-39 % (Fail)', '1', NOW());
END IF;


END $$
CALL V20250317140935__Create_UWC_CCE_Transcript_Report () $$ 
DROP PROCEDURE IF EXISTS V20250317140935__Create_UWC_CCE_Transcript_Report $$ 
DELIMITER ;