DELIMITER $$
DROP PROCEDURE IF EXISTS V20250320105500__Create_MIPS_Child_Grid $$
CREATE PROCEDURE V20250320105500__Create_MIPS_Child_Grid()

BEGIN
SET SQL_SAFE_UPDATES = 0;
    
    IF NOT EXISTS (SELECT 1 FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'mips_payment_gateway') THEN
        CREATE TABLE `mips_payment_gateway` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `academyLocationId` BIGINT(20) NOT NULL,
            `userName` TEXT NOT NULL,
            `password` TEXT NOT NULL,
            `environment` TEXT NOT NULL,
            `merchantID` TEXT NOT NULL,
            `entityID` TEXT NOT NULL,
            `operatorID` TEXT NOT NULL,
            `operatorPassword` TEXT NOT NULL,
            `currency` TEXT NOT NULL,
			`salt` TEXT NOT NULL,
			`cipherKey` TEXT NOT NULL,
            `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            `lastUpdatedBy` BIGINT(20) NOT NULL,
            PRIMARY KEY (`id`),
            INDEX `fk_academylocationid_idx` (`academyLocationId` ASC),
            INDEX `fk_mips_payment_gateway_child_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
            CONSTRAINT `fk_mips_payment_gateway_academylocationid`
                FOREIGN KEY (`academyLocationId`)
                REFERENCES `academy_location` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT,
            CONSTRAINT `fk_mips_payment_gateway_lastUpdatedBy_user_id`
                FOREIGN KEY (`lastUpdatedBy`)
                REFERENCES `users` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT
        );
    END IF;

    IF NOT EXISTS (SELECT 1 FROM standard_master WHERE tableName = 'mips_payment_gateway' LIMIT 1) THEN
        SET @standardMasterMaxId = (SELECT COALESCE(MAX(id)) FROM standard_master);
       
        INSERT INTO `standard_master`(`id`, `tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`)
        VALUES (@standardMasterMaxId + 1, 'mips_payment_gateway', 'MIPS', 'Payment Gateway', 'MASTER_WITH_AL', 1, 0, 1, SYSDATE());
    END IF;

    SET @standardMasterId = (SELECT id FROM standard_master WHERE `tableName` = 'mips_payment_gateway' order by  id desc limit 1);

    IF @standardMasterId IS NOT NULL THEN
        UPDATE `standard_master` SET `childMaster` = @standardMasterId, `whetherParent` = 1 WHERE `tableName` = 'standard_payment_gateway';

        IF NOT EXISTS (SELECT 1 FROM standard_payment_gateway WHERE itemValue = 'MIPS') THEN
            INSERT INTO standard_payment_gateway (itemCode, itemValue, activeStatus, lastUpdate, lastUpdatedBy)  
            VALUES (@standardMasterId, 'MIPS', false, NOW(), 1);
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'academyLocation' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterId, 'Varchar', 1, 1, 'academy_location', 'id', 'academyLocationName', 0, 0, 0, 1, SYSDATE());
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'userName' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('userName', 'USER_NAME', @standardMasterId, 'TextArea', 2, 0, 0, 0, 0, 1, SYSDATE());
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'password' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('password', 'PASSWORD', @standardMasterId, 'TextArea', 3, 0, 0, 0, 0, 1, SYSDATE());
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'environment' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('environment', 'ENVIRONMENT', @standardMasterId, 'TextArea', 4, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'merchantID' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('merchantID', 'MERCHANT_ID', @standardMasterId, 'TextArea', 5, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'entityID' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('entityID', 'ENTITY_ID', @standardMasterId, 'TextArea', 6, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'operatorID' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('operatorID', 'OPERATOR_ID', @standardMasterId, 'TextArea', 7, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'operatorPassword' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('operatorPassword', 'OPERATOR_PASSWORD', @standardMasterId, 'TextArea', 8, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'currency' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('currency', 'CURRENCY', @standardMasterId, 'TextArea', 9, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'salt' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('salt', 'SALT', @standardMasterId, 'TextArea', 10, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'cipherKey' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('cipherKey', 'CIPHER_KEY', @standardMasterId, 'TextArea', 11, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
    END IF;
    SET SQL_SAFE_UPDATES = 1;
END $$

CALL V20250320105500__Create_MIPS_Child_Grid () $$ 
DROP PROCEDURE IF EXISTS V20250320105500__Create_MIPS_Child_Grid $$ 
DELIMITER ;