DELIMITER $$
DROP PROCEDURE IF EXISTS V20250320140810__Create_PayU_Child_Grid $$
CREATE PROCEDURE V20250320140810__Create_PayU_Child_Grid()
BEGIN

SET SQL_SAFE_UPDATES = 0;
    
    IF NOT EXISTS (SELECT 1 FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'payu_payment_gateway') THEN
        CREATE TABLE `payu_payment_gateway` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `academyLocationId` BIGINT(20) NOT NULL,
            `environment` TEXT NOT NULL,
            `supportedPaymentMethods` TEXT NOT NULL,
            `userName` TEXT NOT NULL,
            `password` TEXT NOT NULL,
            `safekey` TEXT NOT NULL,
            `currencyCode` TEXT NOT NULL,
            `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            `lastUpdatedBy` BIGINT(20) NOT NULL,
            PRIMARY KEY (`id`),
            INDEX `fk_academylocationid_idx` (`academyLocationId` ASC),
            INDEX `fk_payu_payment_gateway_child_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
            CONSTRAINT `fk_payu_payment_gateway_academylocationid`
                FOREIGN KEY (`academyLocationId`)
                REFERENCES `academy_location` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT,
            CONSTRAINT `fk_payu_payment_gateway_lastUpdatedBy_user_id`
                FOREIGN KEY (`lastUpdatedBy`)
                REFERENCES `users` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT
        );
    END IF;

    IF NOT EXISTS (SELECT 1 FROM standard_master WHERE tableName = 'payu_payment_gateway' LIMIT 1) THEN
        SET @standardMasterMaxId = (SELECT COALESCE(MAX(id)) FROM standard_master);
       
        INSERT INTO `standard_master`(`id`, `tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`)
        VALUES (@standardMasterMaxId + 1, 'payu_payment_gateway', 'PayU', 'Payment Gateway', 'MASTER_WITH_AL', 1, 0, 1, SYSDATE());
    END IF;

    SET @standardMasterId = (SELECT id FROM standard_master WHERE `tableName` = 'payu_payment_gateway' order by  id desc limit 1);

    IF @standardMasterId IS NOT NULL THEN
        UPDATE `standard_master` SET `childMaster` = @standardMasterId, `whetherParent` = 1 WHERE `tableName` = 'standard_payment_gateway';

        IF NOT EXISTS (SELECT 1 FROM standard_payment_gateway WHERE itemValue = 'PayU') THEN
            INSERT INTO standard_payment_gateway (itemCode, itemValue, activeStatus, lastUpdate, lastUpdatedBy)  
            VALUES (@standardMasterId, 'PayU', false, NOW(), 1);
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'academyLocation' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterId, 'Varchar', 1, 1, 'academy_location', 'id', 'academyLocationName', 0, 0, 0, 1, SYSDATE());
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'environment' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('environment', 'ENVIRONMENT', @standardMasterId, 'TextArea', 2, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
        
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'supportedPaymentMethods' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('supportedPaymentMethods', 'SUPPORTED_PAYMENT_METHODS', @standardMasterId, 'TextArea', 3, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
        
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'userName' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('userName', 'USER_NAME', @standardMasterId, 'TextArea', 4, 0, 0, 0, 0, 1, SYSDATE());
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'password' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('password', 'PASSWORD', @standardMasterId, 'TextArea', 5, 0, 0, 0, 0, 1, SYSDATE());
        END IF;

   
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'safekey' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('safekey', 'SAFE_KEY', @standardMasterId, 'TextArea', 6, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'currencyCode' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('currencyCode', 'CURRENCY_CODE', @standardMasterId, 'TextArea', 7, 0, 0, 0, 0, 1, SYSDATE());
        END IF;
    END IF;
    SET SQL_SAFE_UPDATES = 1;

END $$
CALL V20250320140810__Create_PayU_Child_Grid () $$ 
DROP PROCEDURE IF EXISTS V20250320140810__Create_PayU_Child_Grid $$ 
DELIMITER ;