DELIMITER $$
DROP PROCEDURE IF EXISTS V20250328131559__Update_ExamEmailMarksheetEventsForResit $$
CREATE PROCEDURE V20250328131559__Update_ExamEmailMarksheetEventsForResit()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_RESIT_STATUS_RECIPIENT')) THEN 
SET @dtproviderRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EMAIL_MARKSHEET_FOR_RESIT_STATUS_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
   T1.id AS ID,
  T3.firstName AS FIRST_NAME,
   T3.printName AS STUDENT_PRINT_NAME,
       T3.lastName AS LAST_NAME,
       T3.emailId AS EMAIL_ID,
        T2.code AS STUDENT_ID,
       T8.programNameToBePrint AS PROGRAM_NAME,
       T10.printName AS BATCH_NAME,
       T11.printName AS PERIOD_NAME,
       T19.courseCode AS COURSE_CODE,
       T19.courseName AS COURSE_NAME,
       T7.academyName AS ACADEMY_NAME,
       T7.locationName AS LOCATION_NAME,
       T16.programExamStatus as PROGRESSION_STATUS,
       T23.date as EVENT_DATE,
       now() as PRINT_DATETIME,
       T12.id as JOB_ID,
       T30.remarks as REMARK,
       DATE_FORMAT(T32.conductedDate, '%Y-%m-%d') AS ASSESSMENT_DATE,
       DATE_FORMAT(T32.time, '%H:%i') AS CONDUCTED_TIME

 FROM
   marksheet_job_details T12 
    left join 
       admission T1 on T12.admissionId=T1.id
             left join
            users as T2 on T2.id=T1.studentId
            left join 
            students T25 on T25.userId=T2.id
            left join 
            persons as T3 on T3.id=T25.personId
            left join
            marksheet_job_sub_level as T14 on T14.id=T12.marksheetJobSubLevelId    
            left join
            marksheet_job as T15 on T15.id=T14.marksheetJobId    
            left join 
            academy_location T7 on T7.id=T1.academyLocationId
             left join
            program_batch_students as T16 on T16.progBatchPeriodConfigId=T15.periodId    
            and T16.admissionId=T12.admissionId and T16.sectionId is not null and T16.programExamStatus is not null
             left join
            evaluation_plan_rank as T17 on T17.periodId=T15.periodId    
            and T17.admissionId=T12.admissionId 
            left join
            course_variants as T18 on T18.id=T17.courseVariantId    
            and T17.admissionId=T12.admissionId 
             left join
            courses as T19 on T19.id=T18.courseId    
            left join 
            programs T8 on T8.id=T1.programId
             left join 
            prog_batch_period_config T11 on T11.id=T15.periodId
            left join
            batches T10 on T10.id=T11.programBatchId
              left join 
            lesson_plan_course_variant as T20 on T17.courseVariantId=T20.courseVariantId
              left join  
            lesson_plan as T21 on T20.lessonPlanId=T21.id
              left join 
            lesson_plan_exam_detail as T22 on T21.id=T22.lessonPlanId
              left join 
            event_detail as T23 on T23.lpExamDetailId=T22.id
           inner join 
            progression_panel_decision_template T30 on T30.admissionId=T12.admissionId and T15.periodId=T30.periodId
           left join examination_result T31  ON T31.admissionId = T12.admissionId  AND T16.progBatchPeriodConfigId = T31.periodId    
                      AND T17.courseVariantId = T31.courseVariantId
          left join evaluation_type_course T33   ON T33.periodId = T31.periodId   AND T33.courseVariantId = T31.courseVariantId  
          left join exam_event_detail T32   ON T32.eventId = T31.evaluationDetailSequenceId AND T33.id = T32.evaluationTypeCourseId  
          left join eval_seq_detail T34 ON T34.id = T32.eventId 
   WHERE
     T12.admissionId IN (namedParams) 
    and  T17.status='FAIL'
     and T34.whetherDetailSeqEquivalent is true
      group by T19.id ",
      jsonString='{
     "id": 1,
     "searchResultViewColumns": [
	  {
             "id": 1,
             "value": "code",
             "resultKey": "STUDENT_ID",
             "displayCode": "",
             "displayOrder": 0
	   },
        {
             "id": 2,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 1
	   },
 	    {
            "id": 3,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "batchName",
             "resultKey": "BATCH_NAME",
             "displayCode": "",
             "displayOrder": 3
 	   },
       {
            "id": 5,
             "value": "programPeriodName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 4
 	   },
       {
             "id": 6,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 5
		},
		{
             "id": 7,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 6
         },
         {
             "id": 8,
             "value": "programExamStatus",
             "resultKey": "PROGRESSION_STATUS",
             "displayCode": "",
             "displayOrder": 7
         },
         {
             "id": 9,
             "value": "now()",
             "resultKey": "PRINT_DATETIME",
             "displayCode": "",
             "displayOrder": 8
         },
      {
             "id": 10,
             "value": "remarks",
             "resultKey": "REMARK",
             "displayCode": "",
             "displayOrder": 9
         },
           {
             "id": 11,
             "value": "conductedDate",
             "resultKey": "ASSESSMENT_DATE",
             "displayCode": "",
             "displayOrder": 10
         },
          {
             "id": 12,
             "value": "time",
             "resultKey": "CONDUCTED_TIME",
             "displayCode": "",
             "displayOrder": 11
         }
          
 ]}'

WHERE  dataProviderId =@dtproviderRCPNT;
END IF;

IF EXISTS (SELECT id FROM msg_template_config WHERE `code`='Email marksheet for Resit status Template') THEN 
SET @addUserId=(SELECT id FROM msg_template_config WHERE `code`='Email marksheet for Resit status Template');
UPDATE `msg_template` SET  `msgContent`='<html>
   <head>
   <p style="text-align:right"> $recipientData[&quot;PRINT_DATETIME&quot;]</p>
    <style>
		table, th, td {   
   		 border-collapse: collapse;   		
   		 text-align: center;
		}
	</style>
<tr>
	<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/sommet/sommet_signature6.png" /></td>
 </tr>
   </head>
   <body>
    <p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Progression Panel Results- $recipientData[&quot;studentPrintName&quot;] $recipientData[&quot;studentCode&quot;] $recipientData[&quot;batchName&quot;] $recipientData[&quot;programName&quot;] </span></p>
    	<br>
        <p>Dear Student,</p>
          <p>The Progression Panel has reviewed your overall performance. </p>
          <p> Your results indicate that you have failed and have to resit the following course(s): </p>
     
                        #foreach ($Data in $recipientData[&quot;examFailedCourseList&quot;] ) 
                        <tr>
                           <td style="text-align: left">$Data.courseCode</td>
                      	   <td style="text-align: left">$Data.courseName</td>
                           <td style="text-align: left">$Data.assessmentDate</td>
                           <td style="text-align: left">$Data.conductedTime</td>
                           <br>
						</tr>
                        #end
                         
		  <br><br>
     	  <p>Your resits / resubmissions are scheduled as follows:</p>
			
						#foreach ($Data in $recipientData[&quot;examFailedCourseList&quot;] ) 
                        <tr>
                           <td style="text-align: left">$Data.courseCode</td>
                      	   <td style="text-align: left">$Data.courseName</td>
						   <td style="text-align: left"> - exam on lockdown browser: $Data.eventDate </td>

                           <br>
						</tr>
                        #end

		  <br><br>
          <p>We would also like to emphasize the following points:</p>
		  <br>
		  <p>- Please note all times are SWISS times or UK times depending on the Campus you are currently studying.</p>
          <br>
		  <p>- Please follow this <a href="https://gihe.app.box.com/v/AssessmentGuide"> link </a> to view the following documents relating to on-line exams:</p>
          <p>* On Line Exams and Tests Ã¢ÂÂ How to Guide for Students and technical requirements to be ready for your on-line exam</p>
          <p>* On Line Examination Updates to the Academic Rules and Regulations and Assessment Guide</p>
     	  <p>* General Information Regarding the Use of Video and Audio Monitoring Software for On Line Exams</p>
          <p>* It is extremely important that you read these documents</p>
     	  <p>* Agree to the academic integrity requirement and the data protection requirement</p>
          <p>* Complete the mock exam as a practice test on your Moodle course page before taking your on-line exam. (At least one week before) This will allow you to test the technology.</p>
          <br>
		  <p>If you have a submission, the project outline will be on the Moodle course page on the Monday previous to your submission deadline and you will have
to submit your assessment through TII on your Moodle course page by the deadline.</p>
     	  <p>Please note that lack of knowledge regarding this information will not be accepted as a mitigating circumstance as it has been shared with you in
advance of the exam. Therefore Mitigation will not be accepted.</p>
		  <p>- Failure to attend your exam will result in consequences specified in the <a href="https://gihe.app.box.com/v/RulesandRegulations"> Academic Rules and Regulations </a>, which you can find here.</p>
          <p>- To prepare for your exams, you should refer to existing material related to your course on Moodle, class notes and recommended texts</p>
          <p>If you do not have access to your Moodle homepage or face any other IT issue you must contact <a href="mailto:itsd@sommet-education.com">itsd@sommet-education.com</a> before the exam.</a></p>
          <p>Please check the academic rules and regulations <a href="https://gihe.app.box.com/v/RulesandRegulations">here</a> before contacting us.</p>
          <p>Once you have read the academic rules and regulations and should you have any further questions regarding:</p>
          <ul>
			<li>Your individual grades: please contact your Faculty members</li>
			<li>Your academic progression: please contact your Program Team <a href="mailto:bulle.undergraduateprogram@glion.edu">Undergraduate Program Team.</a><br><br> Best regards.<br>
		Progression Panel</li> 
		</ul>
   </body>
</html>
' WHERE `msgTemplateConfigId`=@addUserId and msgDeliveryModeId = 1;
END IF; 

IF EXISTS (SELECT id FROM msg_template_config WHERE `code`='Email marksheet for Resit status Template') THEN 
SET @addUserId=(SELECT id FROM msg_template_config WHERE `code`='Email marksheet for Resit status Template');
UPDATE `msg_template` SET  `msgContent`='<html>
   <head>
   <p style="text-align:right"> $recipientData[&quot;PRINT_DATETIME&quot;]</p>
    <style>
		table, th, td {   
   		 border-collapse: collapse;   		
   		 text-align: center;
		}
	</style>
<tr>
	<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/sommet/sommet_signature6.png" /></td>
 </tr>
   </head>
   <body>
    <p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Progression Panel Results- $recipientData[&quot;studentPrintName&quot;] $recipientData[&quot;studentCode&quot;] $recipientData[&quot;batchName&quot;] $recipientData[&quot;programName&quot;] </span></p>
    	<br>
        <p>Dear Student,</p>
          <p>The Progression Panel has reviewed your overall performance. </p>
          <p> Your results indicate that you have failed and have to resit the following course(s): </p>
     
                        #foreach ($Data in $recipientData[&quot;examFailedCourseList&quot;] ) 
                        <tr>
                           <td style="text-align: left">$Data.courseCode</td>
                      	   <td style="text-align: left">$Data.courseName</td>
                           <td style="text-align: left">$Data.assessmentDate</td>
                           <td style="text-align: left">$Data.conductedTime</td>
                           <br>
						</tr>
                        #end
                         
		  <br><br>
     	  <p>Your resits / resubmissions are scheduled as follows:</p>
			
						#foreach ($Data in $recipientData[&quot;examFailedCourseList&quot;] ) 
                        <tr>
                           <td style="text-align: left">$Data.courseCode</td>
                      	   <td style="text-align: left">$Data.courseName</td>
						   <td style="text-align: left"> - exam on lockdown browser: $Data.eventDate </td>

                           <br>
						</tr>
                        #end

		  <br><br>
          <p>We would also like to emphasize the following points:</p>
		  <br>
		  <p>- Please note all times are SWISS times or UK times depending on the Campus you are currently studying.</p>
          <br>
		  <p>- Please follow this <a href="https://gihe.app.box.com/v/AssessmentGuide"> link </a> to view the following documents relating to on-line exams:</p>
          <p>* On Line Exams and Tests Ã¢ÂÂ How to Guide for Students and technical requirements to be ready for your on-line exam</p>
          <p>* On Line Examination Updates to the Academic Rules and Regulations and Assessment Guide</p>
     	  <p>* General Information Regarding the Use of Video and Audio Monitoring Software for On Line Exams</p>
          <p>* It is extremely important that you read these documents</p>
     	  <p>* Agree to the academic integrity requirement and the data protection requirement</p>
          <p>* Complete the mock exam as a practice test on your Moodle course page before taking your on-line exam. (At least one week before) This will allow you to test the technology.</p>
          <br>
		  <p>If you have a submission, the project outline will be on the Moodle course page on the Monday previous to your submission deadline and you will have
to submit your assessment through TII on your Moodle course page by the deadline.</p>
     	  <p>Please note that lack of knowledge regarding this information will not be accepted as a mitigating circumstance as it has been shared with you in
advance of the exam. Therefore Mitigation will not be accepted.</p>
		  <p>- Failure to attend your exam will result in consequences specified in the <a href="https://gihe.app.box.com/v/RulesandRegulations"> Academic Rules and Regulations </a>, which you can find here.</p>
          <p>- To prepare for your exams, you should refer to existing material related to your course on Moodle, class notes and recommended texts</p>
          <p>If you do not have access to your Moodle homepage or face any other IT issue you must contact <a href="mailto:itsd@sommet-education.com">itsd@sommet-education.com</a> before the exam.</a></p>
          <p>Please check the academic rules and regulations <a href="https://gihe.app.box.com/v/RulesandRegulations">here</a> before contacting us.</p>
          <p>Once you have read the academic rules and regulations and should you have any further questions regarding:</p>
          <ul>
			<li>Your individual grades: please contact your Faculty members</li>
			<li>Your academic progression: please contact your Program Team <a href="mailto:bulle.undergraduateprogram@glion.edu">Undergraduate Program Team.</a><br><br> Best regards.<br>
		Progression Panel</li> 
		</ul>
   </body>
</html>
' WHERE `msgTemplateConfigId`=@addUserId and msgDeliveryModeId = 4;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250328131559__Update_ExamEmailMarksheetEventsForResit () $$
DROP PROCEDURE IF EXISTS V20250328131559__Update_ExamEmailMarksheetEventsForResit $$
DELIMITER ;