DELIMITER $$
DROP PROCEDURE IF EXISTS d2l3Semesters $$
CREATE PROCEDURE d2l3Semesters()
BEGIN
SELECT
'type', 'action', 'code', 'name', 'start_date', 'end_date', 'is_active', 'department_code', 'template_code', 'semester_code', 'offering_code', 'custom_code'
 UNION
SELECT
'Semester', 'UPDATE', concat(programs.programCode,'-',batches.batchName,'-',period.programPeriodName), concat(programs.programNameToBePrint,'-', batches.batchName,'-',period.printName), DATE_FORMAT(period.programPeriodStart, '%Y-%m-%d'), DATE_FORMAT(period.programPeriodEnd, '%Y-%m-%d'), if(period.programPeriodEnd>= now(), 1,0),'', '', '', '', concat(al.academyCode,'-',al.locationCode)
from prog_batch_period_config as period
join batches on period.programBatchId=batches.id
join programs on batches.programId=programs.id
join academy_location as al on programs.academyLocationId=al.id
JOIN academic_term ON period.academicTermId=academic_term.id AND academic_term.whetherCurrentAcademicTerm=true;
END $$
DELIMITER ;