DELIMITER $$
DROP PROCEDURE IF EXISTS V20250421172917__Update_InactiveAdmissionDataProviderTransl $$
CREATE PROCEDURE V20250421172917__Update_InactiveAdmissionDataProviderTransl()
BEGIN

IF NOT EXISTS ((select * from form_field_info where formAliasName='programperiodformwindow' and formFieldName='attestationLineOne')) THEN 
	INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
	VALUES ('programperiodformwindow','attestationLineOne','attestationLineOne','textfield',0,0,"",1, NOW() ,'Attestation Line 1','','Program Period','Create, Edit, and View','Attestation Line 1',0);
END IF; 

IF NOT EXISTS ((select * from form_field_info where formAliasName='programperiodformwindow' and formFieldName='attestationLineTwo')) THEN 
	INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
	VALUES ('programperiodformwindow','attestationLineTwo','attestationLineTwo','textfield',0,0,"",1, NOW() ,'Attestation Line 2','','Program Period','Create, Edit, and View','Attestation Line 2',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName = 'TRANSLATIONS' AND keyName = 'ATTESTATION_LINE_ONE')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
		VALUES ('TRANSLATIONS','ATTESTATION_LINE_ONE','Attestation Line 1','Attestation Line 1','BewysreÃ«l 1','DÃ²ng chá»©ng thá»±c 1',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName = 'TRANSLATIONS' AND keyName = 'ATTESTATION_LINE_TWO')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
		VALUES ('TRANSLATIONS','ATTESTATION_LINE_TWO','Attestation Line 2','Attestation Line 2','BewysreÃ«l 2','DÃ²ng chá»©ng thá»±c 2',now(),1);
END IF; 
SET @dataLineItemId = (SELECT id FROM dydt_data_line_item WHERE dataSourceCode = 'INACTIVE_ADMISSION_DATA_PROVIDERS');
 IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_CURRENT_SEMESTER_END_DATE') THEN
	INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_CURRENT_SEMESTER_END_DATE', 'Current Semester End date', @dataLineItemId);
END IF; 
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_CURRENT_SEMESTER_START_DATE') THEN
	INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_CURRENT_SEMESTER_START_DATE', 'Current Semester Start date', @dataLineItemId);
END IF;
    
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_CURRENT_PROGRAM_START_DATE') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_CURRENT_PROGRAM_START_DATE', 'Current Program Start Date', @dataLineItemId);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_ATTESTATION_LINE_ONE') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_ATTESTATION_LINE_ONE', 'Attestation Line 1', @dataLineItemId);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_ATTESTATION_LINE_TWO') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_ATTESTATION_LINE_TWO', 'Attestation Line 2', @dataLineItemId);
END IF;
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_PROGRAM_DURATION_SP') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_PROGRAM_DURATION_SP', 'Program Duration - Spanish', @dataLineItemId);
END IF;
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_PROGRAM_DURATION_FR') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_PROGRAM_DURATION_FR', 'Program Duration - French', @dataLineItemId);
END IF;
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_PROGRAM_NAME_SP') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_PROGRAM_NAME_SP', 'Program Name - Spanish', @dataLineItemId);
END IF;
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_PROGRAM_NAME_FR') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_PROGRAM_NAME_FR', 'Program Name - French', @dataLineItemId);
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='prog_batch_period_config' AND column_name='attestationLineOne')) THEN 
ALTER TABLE `prog_batch_period_config` 
ADD COLUMN `attestationLineOne` VARCHAR(60) NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='prog_batch_period_config' AND column_name='attestationLineTwo')) THEN 
ALTER TABLE `prog_batch_period_config` 
ADD COLUMN `attestationLineTwo` VARCHAR(60) NULL DEFAULT NULL;
END IF; 


SET SQL_SAFE_UPDATES=0;
IF EXISTS (SELECT id FROM dydt_data_provider WHERE providerName = 'Inactive Admission Data Providers') THEN
        SET @dydtdataproviderId = (SELECT id FROM dydt_data_provider WHERE providerName = 'Inactive Admission Data Providers');
        UPDATE dydt_data_line_item
        SET 
            sqlSelectQueryDef = 'SELECT 
     CASE 
        WHEN T2.activeStatus=true
	THEN
    (select count(id) from prog_batch_period_config  where programBatchId=(select pbs.programBatchId from program_batch_students pbs  where pbs.admissionId=T2.id and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and  pbs.exitDate is null) and  programPeriodSeq>= (select pbpc.programPeriodSeq from program_batch_students pbs join prog_batch_period_config pbpc on  pbs.progBatchPeriodConfigId=pbpc.id where pbs.admissionId=T2.id and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and pbs.exitDate is null) limit 1)
     ELSE
	(select count(id) from prog_batch_period_config  where programBatchId=( select pbs.programBatchId from program_batch_students pbs  where pbs.admissionId=T2.id order by pbs.id desc limit 1) 
    and  programPeriodSeq>= (select pbpc.programPeriodSeq from program_batch_students pbs join prog_batch_period_config pbpc on  pbs.progBatchPeriodConfigId=pbpc.id where pbs.admissionId=T2.id order by pbs.id desc limit 1)) 
	END AS CURRENT_AND_REMAINING_SEMESTERS,
     date(T388.startDate) AS PROGRAM_DATE_START,
    (select date(pbpc.programPeriodEnd) from student_journey sj
	join prog_batch_period_config pbpc on pbpc.id =sj.periodId where sj.admissionId=T2.id order by sj.id desc limit 1) as APP_PROGRAM_DATE_END,
    if(T4.batchPartTime = TRUE, "Part Time", "Full Time") AS APP_PROGRAM_BATCH_STATUS,
    prop.itemValue AS APP_PROGRAM_DURATION,
    T20.itemValue AS APP_MODE_OF_DELIVERY,
    concat(T299.addressText,",",T100.cityName,",",T111.countryName,",",T121.countryRegionName,",",T299.pincode)  AS APP_STUDENT_PERMANENT_ADDRESS,
    Date(now()) AS APP_CURRENT_DATE,
    T18.firstName AS APP_STUDENT_FIRST_NAME,
    T18.middleName AS APP_STUDENT_MIDDLE_NAME ,
    T18.lastName AS APP_STUDENT_LAST_NAME,
    T17.code AS APP_STUDENT_ID,
    T18.birthDate AS APP_DATE_OF_BIRTH,
    T23.itemValue AS APP_STUDENT_NATIONALITY ,
    concat(T29.addressText,",",T38.cityName,",",T36.countryName,",",T37.countryRegionName,",",T29.pincode) AS APP_STUDENT_CURRENT_ADDRESS,
    T5.programNameToBePrint AS APP_PROGRAM_NAME,
    T4.printName AS APP_PROGRAM_BATCH ,
    T6.printName AS APP_LEVEL_OF_STUDY,
    T50.itemValue AS Period_Year,
    T51.validForm AS VALID_FROM,GROUP_CONCAT(T53.itemValue) AS LEARNING_ALLOWANCE,
    T54.passportNumber AS PASSPORT_NUMBER,
    T56.value AS PERMIT_TYPE,
    T55.permitExpirationDate AS PERMIT_EXPIRATION_DATE,
    T55.dateSubmittedToAuthorities AS PERMIT_DATE_SUBMITTED_TO_AUTHORITIES,
    T23.itemCodeInOtherLanguage AS APP_STUDENT_NATIONALITY_SP,
    T23.itemValueInOtherlanguage AS APP_STUDENT_NATIONALITY_FR,
    T6.programPeriodStart AS APP_CURRENT_SEMESTER_START_DATE,
    T6.programPeriodEnd AS APP_CURRENT_SEMESTER_END_DATE,
    T6.attestationLineOne AS APP_ATTESTATION_LINE_ONE,
    T6.attestationLineTwo AS APP_ATTESTATION_LINE_TWO,
    (select date(pbpc.programPeriodStart) from student_journey sj
	join prog_batch_period_config pbpc on pbpc.id =sj.periodId where sj.admissionId=T2.id and T5.id =sj.programId order by sj.id ASC limit 1) as APP_CURRENT_PROGRAM_START_DATE,
	heqfL.valueInSpanish AS APP_PROGRAM_DURATION_SP, 
    heqfL.valueInFrench AS APP_PROGRAM_DURATION_FR,
	T5.printNameInOtherLanguage1 AS APP_PROGRAM_NAME_SP, 
	T5.printNameInOtherLanguage2 AS APP_PROGRAM_NAME_FR 
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
	LEFT OUTER JOIN heqf_level heqfL on heqfL.id=T5.heqfLevelId
    LEFT OUTER JOIN program_phase prop on prop.id=T5.programPhaseId
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    academy_location T7 ON T7.id = T5.academyLocationId
		LEFT OUTER JOIN
	academy_location_addresses ala on ala.academyLocationId = T7.id
		LEFT OUTER JOIN
    address addr ON addr.id = ala.addressId 
        LEFT OUTER JOIN
    locations T19 ON T19.id = T7.locationId
        LEFT OUTER JOIN
    location_addresses T8 ON T8.locationId = T19.id
        LEFT JOIN
    address T9 ON T9.id = T8.addressId
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT OUTER JOIN
    prog_batch_seat_config T13 ON T13.id = T1.progBatchSeatConfigId
        LEFT OUTER JOIN
    seat_types T14 ON T14.id = T13.seatTypeId
        LEFT OUTER JOIN
    academic_term T15 ON T15.id = T6.academicTermId
        LEFT OUTER JOIN
    intake_year T16 ON T16.id = T4.intakeYearId
        LEFT OUTER JOIN
    users T17 ON T17.id = T3.userId
        LEFT OUTER JOIN
    persons T18 ON T18.id = T3.personId
   LEFT OUTER JOIN gender g ON g.id = T18.genderId
        LEFT OUTER JOIN
    person_addresses pa ON T18.id = pa.personId
        LEFT OUTER JOIN
    address stdaddr ON pa.addressId = stdaddr.id
        LEFT JOIN
    mode_of_delivery T20 ON T20.id = T5.modeOfDeliveryId
       LEFT OUTER JOIN 
    caste_categories T39 on T39.id = T18.castCategoryId
       LEFT OUTER JOIN 
	salutations T21 ON T21.id = T18.salutationId
       Left outer join 
    id_type T22 on T22.id= T18.idTypeId
         Left outer join 
    nationalities T23 on T23.id = T18.nationalityId
		 Left outer join 
    drop_down T26 on T26.id = T18.homeLanguage
         LEFT OUTER JOIN 
    person_addresses T27 on T27.personId = T18.id and T27.addressTypeId = 5
         LEFT OUTER JOIN 
    address_type T28 on T28.id = T27.addressTypeId and T28.code = "CRNT" and T28.addressCategory = "PERSON"
         LEFT OUTER JOIN 
    address T29 on T29.id = T27.addressId and T29.addressTypeId=T27.addressTypeId
		 LEFT OUTER JOIN
    city T38 ON T38.id = T29.cityId
         LEFT OUTER JOIN
    country_region T37 ON T37.id = T38.countryRegionId
        LEFT OUTER JOIN
    country T36 ON T36.id = T37.countryId
   LEFT OUTER JOIN
   person_addresses T277 on T277.personId = T18.id and T277.addressTypeId = 7
         LEFT OUTER JOIN 
    address_type T288 on T288.id = T277.addressTypeId and T288.code = "PRMNT" and T288.addressCategory = "PERSON"  
         LEFT OUTER JOIN 
    address T299 on T299.id = T277.addressId and T288.id=T277.addressTypeId
     LEFT OUTER JOIN
    city T100 ON T100.id = T299.cityId
        LEFT OUTER JOIN
    country T111 ON T111.id = T100.countryId
        LEFT OUTER JOIN
    country_region T121 ON T121.id = T100.countryRegionId
    LEFT OUTER JOIN 
    student_status sstatus on sstatus.id=T18.studentStatusId 
    LEFT OUTER JOIN 
    period_event_name_csm pevent on pevent.itemCode=concat(sstatus.itemCode,"-Semester Dates")
    LEFT OUTER JOIN
    period_activity_date_details T388 ON T388.programBatchPeriodConfigurationId = T6.id and pevent.id=T388.periodEventId
    LEFT OUTER JOIN period_year T50 ON T50.id = T6.periodYearId
    LEFT OUTER JOIN learning_allowance T51 ON T51.personId = T18.id
    LEFT OUTER JOIN learning_allowance_csm_mapping T52 ON T52.learning_allowance_id = T51.id
    LEFT OUTER JOIN learning_allowances_csm T53 ON T53.id = T52.learning_allowance_CSM_Id
    LEFT OUTER JOIN (
    SELECT * FROM student_passport_detail spd1
    WHERE spd1.id = (SELECT spd2.id FROM student_passport_detail spd2 WHERE spd2.personId = spd1.personId ORDER BY spd2.isPrimary DESC,spd2.lastUpdate DESC LIMIT 1)
    ) T54 ON T18.id = T54.personId
    LEFT OUTER JOIN (
    SELECT * FROM permit_detail pd1
    WHERE pd1.id = (SELECT pd2.id FROM permit_detail pd2 WHERE pd2.personId = pd1.personId ORDER BY pd2.isPrimary DESC, pd2.lastUpdate DESC LIMIT 1)
    ) T55 ON T18.id = T55.personId 
    LEFT OUTER JOIN drop_down T56 ON T56.id = T55.permitTypeId',resultColumnsDef = 'CURRENT_AND_REMAINING_SEMESTERS, PROGRAM_DATE_START, APP_PROGRAM_DATE_END, APP_PROGRAM_BATCH_STATUS, APP_PROGRAM_DURATION, APP_MODE_OF_DELIVERY, APP_STUDENT_PERMANENT_ADDRESS, APP_CURRENT_DATE, APP_STUDENT_FIRST_NAME, APP_STUDENT_MIDDLE_NAME, APP_STUDENT_LAST_NAME, APP_STUDENT_ID, APP_DATE_OF_BIRTH, APP_STUDENT_NATIONALITY, APP_STUDENT_CURRENT_ADDRESS, APP_PROGRAM_NAME, APP_PROGRAM_BATCH, APP_LEVEL_OF_STUDY, Period_Year,VALID_FROM, LEARNING_ALLOWANCE,
    PASSPORT_NUMBER, PERMIT_TYPE, PERMIT_EXPIRATION_DATE, PERMIT_DATE_SUBMITTED_TO_AUTHORITIES, APP_STUDENT_NATIONALITY_SP, APP_STUDENT_NATIONALITY_FR,APP_CURRENT_SEMESTER_START_DATE,APP_CURRENT_SEMESTER_END_DATE,APP_ATTESTATION_LINE_ONE,APP_ATTESTATION_LINE_TWO,APP_CURRENT_PROGRAM_START_DATE,APP_PROGRAM_NAME_SP,APP_PROGRAM_NAME_FR' WHERE 
            dataSourceCode = 'INACTIVE_ADMISSION_DATA_PROVIDERS'
            AND dataProviderId = @dydtdataproviderId;
    END IF;

SET SQL_SAFE_UPDATES=1;

IF EXISTS (SELECT id FROM dydt_data_provider WHERE providerName = 'Inactive Admission Data Providers') THEN
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId = (SELECT dataProviderId FROM `dydt_data_line_item` where dataSourceCode='INACTIVE_ADMISSION_DATA_PROVIDERS');
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'ATTESTATION_TABLE_ONE', '3',null, '1', '0', 
'SELECT 
    pbpc.printName AS PERIOD_NAME,
    pbpc.attestationLineOne AS ATTESTATION,
    CONCAT(CASE
                WHEN
                    (SELECT 
                            c.ectsCredits
                        FROM
                            program_courses_period pcpcourseCredits
                                JOIN
                            prog_batch_period_config pbpccourseCredits ON pbpccourseCredits.id = pcpcourseCredits.periodId
                                JOIN
                            program_courses pccourseCredits ON pccourseCredits.id = pcpcourseCredits.programCourseId
                                JOIN
                            courses ccourseCredits ON ccourseCredits.id = pccourseCredits.courseId
                        WHERE
                            pcpcourseCredits.periodId = pbpc.id
                                AND ccourseCredits.ectsCredits IS NOT NULL
                                AND ccourseCredits.ectsCredits > 0
                        LIMIT 1) > 0
                THEN
                    "☑ ECTS&nbsp;&nbsp;&nbsp;"
                ELSE "☐ ECTS&nbsp;&nbsp;&nbsp;"
            END,
            CASE
                WHEN
                    (SELECT 
                            c.courseCredits
                        FROM
                            program_courses_period pcpcourseCredits
                                JOIN
                            prog_batch_period_config pbpccourseCredits ON pbpccourseCredits.id = pcpcourseCredits.periodId
                                JOIN
                            program_courses pccourseCredits ON pccourseCredits.id = pcpcourseCredits.programCourseId
                                JOIN
                            courses ccourseCredits ON ccourseCredits.id = pccourseCredits.courseId
                        WHERE
                            pcpcourseCredits.periodId = pbpc.id
                                AND ccourseCredits.courseCredits IS NOT NULL
                                AND ccourseCredits.courseCredits > 0
                        LIMIT 1) > 0
                THEN
                    "☑ US "
                ELSE "☐ US"
            END) AS CREDIT
FROM
    program_courses_period pcp
        JOIN
    prog_batch_period_config pbpc ON pbpc.id = pcp.periodId
        JOIN
    program_courses pc ON pc.id = pcp.programCourseId
        JOIN
    courses c ON c.id = pc.courseId
        JOIN
    student_journey sj ON sj.periodId = pcp.periodId', 'PRM_ADMISSION_ID', 
	'PERIOD_NAME,ATTESTATION,CREDIT',
' where sj.admissionId=PRM_ADMISSION_ID group by pbpc.id', '1');


IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dydtdatalinitemId+1 AND translationCode = 'PERIOD_NAME') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('PERIOD_NAME', 'Period Name', @dydtdatalinitemId+1);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dydtdatalinitemId+1 AND translationCode = 'ATTESTATION') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('ATTESTATION', 'Attestation', @dydtdatalinitemId+1);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dydtdatalinitemId+1 AND translationCode = 'CREDIT') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('CREDIT', 'Credit', @dydtdatalinitemId+1);
END IF;


SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId = (SELECT dataProviderId FROM `dydt_data_line_item` where dataSourceCode='INACTIVE_ADMISSION_DATA_PROVIDERS');
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'ATTESTATION_TABLE_TWO', '4',null, '1', '0', 
'select pbpc.printName AS PERIOD_NAME,concat(pbpc.attestationLineOne,"<br><i>",pbpc.attestationLineTwo,"</i>") AS ATTESTATIONS from program_courses_period pcp
join prog_batch_period_config pbpc on pbpc.id=pcp.periodId
join program_courses pc on pc.id=pcp.programCourseId
join courses c on c.id=pc.courseId
join student_journey sj on sj.periodId=pcp.periodId', 'PRM_ADMISSION_ID', 
	'PERIOD_NAME,ATTESTATIONS',
' where sj.admissionId=PRM_ADMISSION_ID group by pbpc.id', '1');


IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dydtdatalinitemId+1 AND translationCode = 'PERIOD_NAME') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('PERIOD_NAME', 'Period Name', @dydtdatalinitemId+1);
END IF;

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dydtdatalinitemId+1 AND translationCode = 'ATTESTATIONS') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('ATTESTATIONS', 'Attestations', @dydtdatalinitemId+1);
END IF;

END IF;
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from data_grid where gridName='Academia.view.program.programDetails.programBatchDetails.periods.ProgramPeriodsGrid' and portalId=1)) THEN 
UPDATE `data_grid` SET `jsonObject`='[{"id":null,"columnName":"PROGRAM_BATCH_PERIOD_NAME","dataIndex":"programPeriodName","columnVisibility":"SHOW","sequence":1,"mandatory":false},
 {"id":null,"columnName":"PROGRAM_SEQUENCE","dataIndex":"programPeriodSeq","columnVisibility":"SHOW","sequence":2,"mandatory":false},
 {"id":null,"columnName":"ACADEMIC_TERM","dataIndex":"academicTerm","columnVisibility":"HIDE","sequence":3,"mandatory":false},
 {"id":null,"columnName":"OPTIONAL_PERIOD","dataIndex":"whetherOptionalPeriod","columnVisibility":"HIDE","sequence":4,"mandatory":false},
 {"id":null,"columnName":"PERIOD_START","dataIndex":"programPeriodStartDate","columnVisibility":"SHOW","sequence":5,"mandatory":false},
 {"id":null,"columnName":"PERIOD_END","dataIndex":"programPeriodEndDate","columnVisibility":"SHOW","sequence":6,"mandatory":false},
 {"id":null,"columnName":"MINIMUM_COURSES","dataIndex":"minCourses","columnVisibility":"SHOW","sequence":7,"mandatory":false},
 {"id":null,"columnName":"MAXIMUM_COURSES","dataIndex":"maxCourses","columnVisibility":"SHOW","sequence":8,"mandatory":false},
 {"id":null,"columnName":"MINIMUM_CREDITS","dataIndex":"minCredits","columnVisibility":"HIDE","sequence":9,"mandatory":false},
 {"id":null,"columnName":"MAXIMUM_CREDITS","dataIndex":"maxCredit","columnVisibility":"HIDE","sequence":10,"mandatory":false},
 {"id":null,"columnName":"SET_DEADLINE_ENROLLMENT","dataIndex":"enrollmentLastDate","columnVisibility":"HIDE","sequence":11,"mandatory":false},
 {"id":null,"columnName":"REGISTRATION_SETUP_NAME","dataIndex":"registrationSetupName","columnVisibility":"HIDE","sequence":12,"mandatory":false},
 {"id":null,"columnName":"CURRENT_PERIOD_OF_PROGRAM","dataIndex":"isCurrentPeriodOfProgram","columnVisibility":"HIDE","sequence":13,"mandatory":false},
 {"id":null,"columnName":"PERIOD_YEAR","dataIndex":"periodYear","columnVisibility":"SHOW","sequence":14,"mandatory":false},
 {"id":null,"columnName":"IS_LAST_PERIOD","dataIndex":"isLastPeriodOfProgram","columnVisibility":"HIDE","sequence":15,"mandatory":false},
 {"id":null,"columnName":"CAMPUS","dataIndex":"campus","columnVisibility":"HIDE","sequence":16,"mandatory":false},
 {"id":null,"columnName":"COMPUTER_USER_AREA","dataIndex":"computerUserAreaValue","columnVisibility":"HIDE","sequence":17,"mandatory":false},
 {"id":null,"columnName":"ATTESTATION_LINE_ONE","dataIndex":"attestationLineOne","columnVisibility":"HIDE","sequence":18,"mandatory":false},
 {"id":null,"columnName":"ATTESTATION_LINE_TWO","dataIndex":"attestationLineTwo","columnVisibility":"HIDE","sequence":19,"mandatory":false}]'
  where gridName='Academia.view.program.programDetails.programBatchDetails.periods.ProgramPeriodsGrid' and portalId=1;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250421172917__Update_InactiveAdmissionDataProviderTransl () $$
DROP PROCEDURE IF EXISTS V20250421172917__Update_InactiveAdmissionDataProviderTransl $$
DELIMITER ;