DELIMITER $$
DROP PROCEDURE IF EXISTS V20250424185740__Update_HOMEWORK_ASSIGNMENT_ADHOC $$
CREATE PROCEDURE V20250424185740__Update_HOMEWORK_ASSIGNMENT_ADHOC()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='HOMEWORK_ASSIGNMENT_STUDENT_ADHOC')) THEN 

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOMEWORK_ASSIGNMENT_STUDENT_ADHOC');
update `sql_dtprovider` set `sqlQuery` = "SELECT 
    T1.id AS ID,
    T6.id AS DATA_ID,
    T4.firstName AS FIRST_NAME,
    T4.lastName AS LAST_NAME,
    T4.printName AS PRINT_NAME,
    T4.emailId AS EMAIL_ID,
    T4.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T4.mobileNumber AS MOBILE_NO,
    T4.mobileCountryCode AS MOBILE_CODE,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    T6.assignmentName AS ASSIGNMENT_NAME,
    T8.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T8.courseCode AS COURSE_CODE,
    T7.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,
    DATE_FORMAT(T6.dateSubmitted, '%d-%m-%Y %H:%i:%s') AS CURRENT_DATE_TIME,
   	group_concat(distinct f.deviceTokenId) AS DEVICE_ID,
    'HOMEWORK_ASSIGNMENTS' AS MSG_CATEGORY
FROM
    group_hw_assignment T1
        LEFT JOIN
    admission AS T2 ON T2.id = T1.admissionId
        LEFT JOIN
    students AS T3 ON T3.userId = T2.studentId
        LEFT JOIN
    persons AS T4 ON T4.id = T3.personId
        LEFT JOIN
    academy_location T5 ON T5.id = T2.academyLocationId
        LEFT JOIN
    course_hw_asignment T6 ON T6.id = T1.hwAssignmentId
        LEFT JOIN
    course_variants T7 ON T7.id = T6.courseVariantId
        LEFT JOIN
    courses T8 ON T8.id = T7.courseId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T3.userId
WHERE
    T1.id IN (namedParams)" where `dataProviderId` = @dtproviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM msg_recipient_type WHERE `code`='HOMEWORK_ASSIGNMENT_STUDENT_ADHOC')) THEN 
 SET @recipientTypeId=(SELECT id FROM msg_recipient_type WHERE `code`='HOMEWORK_ASSIGNMENT_STUDENT_ADHOC');
 UPDATE `msg_template_config` SET `recipientTypeId` = @recipientTypeId WHERE code = 'Homework Assignment Allocation';
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250424185740__Update_HOMEWORK_ASSIGNMENT_ADHOC () $$
DROP PROCEDURE IF EXISTS V20250424185740__Update_HOMEWORK_ASSIGNMENT_ADHOC $$
DELIMITER ;