DELIMITER $$
DROP PROCEDURE IF EXISTS getMultiEmailAdmissionDetails $$
CREATE PROCEDURE getMultiEmailAdmissionDetails(IN studCode VARCHAR(50))
BEGIN
SELECT distinct
        pr.firstName AS firstName, 
        pr.lastName AS lastName, 
        pr.emailId AS primaryStudentEmail,  
        u.code AS studentId, 
        u.status AS studentIdStatus, 
        pr.externalSysRefOne AS inStudentIdGIHE, 
        pr.externalSysRefThree AS inStudentIDLRCM,
        pr.externalSysRefTwo AS inStudentIDLRM, 
        pr.motivation AS classNumber, 
        eaudit.emailId AS studentEmail, 
        p.programCode AS programCode, 
        p.programName AS program, 
        sj.resultStatus AS enrollmentStatus, 
        al.academyName AS companyName, 
        CONCAT(al.academyName, ' ', al.locationName) AS academyLocation, 
        a.activeStatus AS admissionIDStatus, 
        dd.name AS campus, 
        aterm.itemValue AS academicTerm,  
        b.batchName AS batch,
        period.programPeriodName AS programBatchPeriod, 
        admreson.itemCode AS admissionInactiveReason
    FROM manage_student_email_audit eaudit
    JOIN users u ON eaudit.studentId = u.id
    JOIN students s ON s.userId = u.id
    JOIN persons pr ON s.personId = pr.id
    JOIN admission a ON eaudit.admissionId = a.id
    JOIN student_journey sj ON sj.admissionId = a.id and sj.isActive=true
    JOIN academy_location al ON a.academyLocationId = al.id
    JOIN prog_batch_period_config period ON sj.periodId = period.id
    JOIN academic_term aterm ON aterm.id = period.academicTermId
    JOIN batches b ON sj.programBatchId = b.id
    JOIN programs p ON b.programId = p.id
    LEFT JOIN admission_inactive_reason admreson ON a.inactiveReasonCode = admreson.id
    LEFT JOIN academy_location_campus alcampus ON sj.academyCampusId = alcampus.id AND sj.academyLocationId = al.id
    LEFT JOIN drop_down dd ON alcampus.campusId = dd.id
    WHERE u.code = studCode group by eaudit.id;
END$$

DELIMITER ;