DELIMITER $$
DROP PROCEDURE IF EXISTS V20250520120039__Create_UnitOfAssessment $$
CREATE PROCEDURE V20250520120039__Create_UnitOfAssessment()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='unit_of_assessment')) THEN 
CREATE TABLE `unit_of_assessment` (
		`id` bigint(20) NOT NULL AUTO_INCREMENT,
		  `itemCode` varchar(255) NOT NULL,
		  `itemValue` varchar(255) NOT NULL,
		   `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `lastUpdatedBy` bigint(20) NOT NULL,
		  PRIMARY KEY (`id`),
		 KEY `fk_unit_of_assessment_updateby` (`lastUpdatedBy`),
		  CONSTRAINT `unit_of_assessment_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) 
			  ON DELETE NO ACTION 
			  ON UPDATE NO ACTION
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 


IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'unit_of_assessment')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1,'unit_of_assessment','UNIT_OF_ASSESSMENT','Admissions','COMMON_MASTER',0,0,1,SYSDATE());
			
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',SYSDATE());
				
	END IF; 
    
END $$
CALL V20250520120039__Create_UnitOfAssessment () $$ 
DROP PROCEDURE IF EXISTS V20250520120039__Create_UnitOfAssessment $$ 
DELIMITER ;