DELIMITER $$
DROP PROCEDURE IF EXISTS V20250520125937__Insert_ProgramRolesMapping $$
CREATE PROCEDURE V20250520125937__Insert_ProgramRolesMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.tables    WHERE table_schema = DATABASE() AND table_name = 'program_roles_mapping')) THEN 
CREATE TABLE `program_roles_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `programRoleId` BIGINT NOT NULL,
  `programRoleTypeId` BIGINT NOT NULL,
  `programId`  BIGINT NOT NULL,
  `programRoleProportion` double  DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  
  PRIMARY KEY (`id`),
  INDEX `fk_program_roles_mapping_programRoleId_idx` (`programRoleId` ASC),
  INDEX `fk_program_roles_mapping_programId_idx` (`programId` ASC),
   INDEX `fk_program_roles_mapping_programRoleTypeId_idx` (`programRoleTypeId` ASC),
  INDEX `fk_program_roles_mapping_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
 

  CONSTRAINT `fk_program_roles_mapping_programRoleId`
    FOREIGN KEY (`programRoleId`)
    REFERENCES `program_roles` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

CONSTRAINT `fk_program_roles_mapping_programId`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
    
    CONSTRAINT `fk_program_roles_mapping_programRoleTypeId`
    FOREIGN KEY (`programRoleTypeId`)
    REFERENCES `program_roles_type` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
    
  CONSTRAINT `fk_program_roles_mapping_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION
    
) ;

END IF;

END $$
CALL V20250520125937__Insert_ProgramRolesMapping() $$
DROP PROCEDURE IF EXISTS V20250520125937__Insert_ProgramRolesMapping $$
DELIMITER ;