DELIMITER $$
DROP PROCEDURE IF EXISTS getHesaCourseData $$
CREATE PROCEDURE getHesaCourseData(IN programIds bigint)
BEGIN
SELECT DISTINCT
        -- HESA Course Parent
        p.id AS PID,
        p.programCode AS COURSEID,
        pOtherDetails.programAligned AS CLSDCRS,
        p.programNameToBePrint AS COURSETITLE,
        pOtherDetails.programPGAidEligible AS FULLYFLEX,
        pEndorsement.itemCode AS PREREQUISITE,
        p.programCode AS QUALID,
        pCESM.itemCode AS SANDWICH,
        academicAward.itemCode AS TTCID,

        -- HESA Course Initiative
        pSpecific.itemCode AS COURSEINITID,
        pInitiative.startDate AS COURSEINITVALIDFROM,
        pInitiative.endDate AS COURSEINITVALIDTO,

        -- HESA Course Reference
        pOtherDetails.programHEQSFType2015 AS COURSEREFRNCID,
        dDown.name AS COURSEREFRNCIDTYPE,

        -- HESA Course Role
        pRoles.itemCode AS COURSEROLEHESAID,
        pRoleMapping.programRoleProportion AS CRPROPORTION,
        pRoleType.itemCode AS ROLETYPE,

        -- HESA Curriculum Accreditation
        progCurriculamAcc.itemCode AS CURACCID,
        progCurriculamAccMapping.startDate AS CURACCVALIDFROM,
        progCurriculamAccMapping.endDate AS CURACCVALIDTO

    FROM programs p
    LEFT JOIN program_other_details pOtherDetails ON p.id = pOtherDetails.programId
    LEFT JOIN program_endorsement pEndorsement ON p.programEndorsementId = pEndorsement.id
    LEFT JOIN program_phase pCESM ON p.programPhaseId = pCESM.id
    LEFT JOIN academic_award academicAward ON p.academicAwardId = academicAward.id
    LEFT JOIN drop_down dDown ON dDown.id = pOtherDetails.hEQSFTypeId

    -- Initiatives
    LEFT JOIN program_initiative_mapping pInitiative ON p.id = pInitiative.programId
    LEFT JOIN program_specific_initiative pSpecific ON pSpecific.id = pInitiative.programSpecificInitiativeId

    -- Roles
    LEFT JOIN program_roles_mapping pRoleMapping ON pRoleMapping.programId = p.id
    LEFT JOIN program_roles pRoles ON pRoles.id = pRoleMapping.programRoleId
    LEFT JOIN program_roles_type pRoleType ON pRoleType.id = pRoleMapping.programRoleTypeId

    -- Accreditations
    LEFT JOIN curriculum_accrediation_mapping progCurriculamAccMapping ON progCurriculamAccMapping.programId = p.id
    LEFT JOIN curriculum_accrediation progCurriculamAcc ON progCurriculamAccMapping.curriculumAccrediationId = progCurriculamAcc.id

    WHERE p.id = programIds;

END $$
DELIMITER ;