DELIMITER $$

DROP PROCEDURE IF EXISTS hesa_studentdetails $$

CREATE PROCEDURE hesa_studentdetails(
    IN p_programId BIGINT,
    IN p_academicTermId BIGINT
)
BEGIN
    SELECT DISTINCT
        adm.id AS NUMHUS,
        gr.itemCode AS SEXID,
        prn.id AS SID,
        prn.haveDisabilities AS DISABILITY,
        adm.admissionDate AS ENGSTARTDATE,
        eh.examResult AS ENTRYQUALAWARDID,
        rs.itemCode AS ENTRYQUALAWARDRESULT,
        ep.itemCode AS QUALTYPEID,
        sr.withdrawalReason AS RSNENGEND,
        pcd.awardCertificate AS QUALAWARDID,
        ps.programCode AS QUALID,
        ps.accreditationProgramAccreditation AS QUALAWARDACCID,
        ps.accreditationProgramAccreditation AS STUACCID,
        ps.id AS COURSEID,
        (SELECT CASE 
                 WHEN pt.placementType = 'Off-Campus' THEN 'Off-Campus' 
                 ELSE NULL 
               END) AS OVAID,
        pbpc.id AS SCSESSIONID,
        mody.itemCode AS SCSMODE,
        pbpc.programPeriodStart AS SCSSTARTDATE,
        fb.itemCode AS FUNDINGBODY,
        cs.id AS MODID,
        pc.moduleInstanceIdentifier AS MODINSTID,
        DATEDIFF(pc.endDate, pc.startDate) AS ACTDURATION,
        adt.itemCode AS ACTDURATIONTYPE,
        ati.itemCode AS ACTTYPEID,
        ctry.code AS COUNTRY,
        ms.itemCode AS MOBSCHEME,
        pbpc.programPeriodName AS RPSTULOAD,
        py.itemCode AS `YEAR`,
        ss.itemCode AS STATUSCHANGEDTO,
        ss.lastUpdate AS STATUSVALIDFROM,
        al.academyCode AS STUDYLOCID,
        100 AS STUDYPROPORTION,
        stte.supervisorIdentifier AS SUPALLID,
        stte.supervisorProportion AS SUPALLPROP,
        psi.itemCode AS STUINITID,
        pbpc.id AS REFPERIOD,
        fst.itemCode AS FINSUPTYPE,
        c.effectiveDate AS ENGENDDATE
    FROM admission adm
    JOIN program_batch_students pbs ON pbs.admissionId = adm.id
        AND pbs.isCurrentPeriod = 1
        AND pbs.isCurrentSection = 1
        AND pbs.exitDate IS NULL
    LEFT JOIN completions c ON c.admissionId = adm.id
    LEFT JOIN students stu ON adm.studentId = stu.userId
    LEFT JOIN persons prn ON prn.id = stu.personId
    LEFT JOIN users us ON us.id = stu.userId
    LEFT JOIN prog_batch_period_config pbpc ON pbpc.id = pbs.progBatchPeriodConfigId
    LEFT JOIN batches btc ON pbs.programBatchId = btc.id
    LEFT JOIN programs ps ON ps.id = btc.programId
    LEFT JOIN gender gr ON prn.genderId = gr.id
    LEFT JOIN education_histories eh ON eh.personId = prn.id AND eh.whetherDeleted = 0
    LEFT JOIN result_status rs ON rs.id = eh.resultStatusId
    LEFT JOIN exam_passed ep ON eh.examPassedId = ep.id
    LEFT JOIN service_requests sr ON sr.requester = stu.userId
    LEFT JOIN program_completion_details pcd ON pcd.admissionId = adm.id
    LEFT JOIN mode_of_delivery mody ON btc.modeOfDeliveryId = mody.id
    LEFT JOIN funding_body fb ON fb.id = prn.id
    LEFT JOIN student_course_enrollment sce ON adm.id = sce.admissionId 
        AND pbs.progBatchPeriodConfigId = sce.programBatchPeriodConfigId
    LEFT JOIN course_variants cv ON sce.courseVarientId = cv.id
    LEFT JOIN courses cs ON cs.id = cv.courseId
    LEFT JOIN placement_type pt ON pbpc.placementTypeId = pt.id
    LEFT JOIN placement_campus pc ON pc.placementTypeId = pt.id
    LEFT JOIN activity_duration_type adt ON adt.id = pc.activityDurationTypeId
    LEFT JOIN activity_type_identifier ati ON ati.id = pc.activityTypeIdentifierId
    LEFT JOIN person_addresses pad ON prn.id = pad.personId AND pad.whetherDeleted = 0
    LEFT JOIN address addr ON pad.addressId = addr.id
    LEFT JOIN country ctry ON addr.countryId = ctry.id
    LEFT JOIN mobile_scheme ms ON ms.id = pc.mobileSchemeId
    LEFT JOIN period_year py ON py.id = pbpc.periodYearId
    LEFT JOIN student_status ss ON ss.id = adm.stdAdmissionStatusId
    LEFT JOIN academy_location al ON al.id = adm.academyLocationId
    LEFT JOIN student_thesis_title stte ON stte.programId = ps.id
    LEFT JOIN program_initiative_mapping pim ON pim.programId = ps.id
    LEFT JOIN program_specific_initiative psi ON psi.id = pim.programSpecificInitiativeId
    LEFT JOIN financial_support fs ON fs.id = stu.userId
    LEFT JOIN financial_support_type fst ON fst.id = fs.financialSupportTypeId
    WHERE pbpc.academicTermId = p_academicTermId
      AND ps.id = p_programId
    GROUP BY adm.id;
END $$

DELIMITER ;