DELIMITER $$
DROP PROCEDURE IF EXISTS V20250610142336__Create_sponsor_invoice_document $$
CREATE PROCEDURE V20250610142336__Create_sponsor_invoice_document()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='sponsor_invoice_document')) THEN 
CREATE TABLE `sponsor_invoice_document`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`sponsorInvoiceId` bigint(20) Default Null,
	`documentId` bigint(20) Default Null,
	`documentName` varchar(255) Default Null,
	`lastUpdatedBy` bigint(20) NOT NULL,
	`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (id),
	INDEX `fk_sponsor_invoice_document_to_sponsor_invoice__idx`(`sponsorInvoiceId`),
	INDEX `fk_sponsor_invoice_document_to_user_idx` (`lastUpdatedBy`) ,
  
  CONSTRAINT `fk_sponsor_invoice_document_to_sponsor_invoice__idx` 
	FOREIGN KEY (`sponsorInvoiceId`) 
	REFERENCES `sponsor_invoice`(`id`)
    ON DELETE RESTRICT
	ON UPDATE RESTRICT,
 
  CONSTRAINT `fk_sponsor_invoice_document_to_user_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);END IF; 

END $$
CALL V20250610142336__Create_sponsor_invoice_document () $$ 
DROP PROCEDURE IF EXISTS V20250610142336__Create_sponsor_invoice_document $$ 
DELIMITER ;