DELIMITER $$
DROP PROCEDURE IF EXISTS V20250616182228__Update_StudentCourseEnrollmentInfo $$
CREATE PROCEDURE V20250616182228__Update_StudentCourseEnrollmentInfo()
BEGIN
SET SQL_SAFE_UPDATES=0;
set @dataProviderId=(select id from dydt_data_provider where providerName="Registration Confirmation Letter Dynamic Document" limit 1);
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO' and dataProviderId=@dataProviderId limit 1)) THEN 
update dydt_data_line_item set sqlSelectQueryDef = 'SELECT IFNULL(co.courseCode, c.courseCode) AS COURSE_CODE,
    IFNULL(co.courseName, c.courseName) AS COURSE_NAME,
FLOOR ( c.courseCredits) 
AS COURSE_CREDITS, 
pbpc.printName AS PERIOD , ss.examDate AS EXAM_DATE, 
DATE_FORMAT(ss.examStartTime,"%h:%i %p") AS EXAM_START_TIME, 
DATE_FORMAT(ss.examEndTime,"%h:%i %p") 
AS EXAM_END_TIME,IF(program_courses.isOfferedYearly = 1,
        "Yes",
        "No") AS YEARLY_MODULE
from student_course_enrollment sce
inner 
join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id
inner join period_year py on pbpc.periodYearId=py.id
inner join drop_down dd on dd.name="Yearly Proof of Registration"
inner 
join admission adm on adm.id=sce.admissionId
inner join course_variants cv on cv.id=sce.courseVarientId
INNER JOIN sections ss on ss.id = sce.sectionId
left join courses c on c.id=cv.courseId
LEFT JOIN courses co ON co.id = c.parentCourseId
LEFT JOIN program_courses ON c.parentCourseId = program_courses.courseId AND pbpc.programBatchId = program_courses.programBatchId' , 

sqlWhereQueryDef = 'WHERE adm.id=1813 and ((LOWER(dd.value)="no" and sce.programBatchPeriodConfigId>=(
select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=1813 and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and 
pbs.exitDate is null
)) OR (LOWER(dd.value)="yes" and py.id=(
select pyp.id from program_batch_students pbs join prog_batch_period_config pbpcp on pbs.progBatchPeriodConfigId=pbpcp.id inner join period_year pyp on pbpcp.periodYearId=pyp.id where pbs.admissionId=1813 and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and 
pbs.exitDate is null
)) )and sce.exitDate is null and adm.activeStatus=true'

where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO' and dataProviderId=@dataProviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250616182228__Update_StudentCourseEnrollmentInfo () $$
DROP PROCEDURE IF EXISTS V20250616182228__Update_StudentCourseEnrollmentInfo $$
DELIMITER ;