DELIMITER $$
DROP PROCEDURE IF EXISTS V20250626144653__Update_STd_Acad_TENUER_INFO_update_details $$
CREATE PROCEDURE V20250626144653__Update_STd_Acad_TENUER_INFO_update_details()
BEGIN
SET SQL_SAFE_UPDATES=0;


IF EXISTS (SELECT id FROM dydt_data_provider WHERE providerName = 'STUDENT_ACADEMIC_TENUER_INFO') THEN
        SET @dydtdataproviderId = (SELECT id FROM dydt_data_provider WHERE providerName = 'STUDENT_ACADEMIC_TENUER_INFO');
        UPDATE dydt_data_line_item
        SET 
            sqlSelectQueryDef = 'select
         period.programPeriodName as period_name,
 		b.batchName as batch_name
     from
         program_batch_students pbs 
     left outer join
         admission adm 
             on pbs.admissionId=adm.id 
     left outer join
         students std 
            on adm.studentId=std.userId
 	 left outer join
         prog_batch_period_config period 
             on period.id=progBatchPeriodConfigId 
             Left outer join batches b on b.id=period.programbatchId
            LEFT OUTER JOIN (
    SELECT spcp1.*
    FROM student_print_certificate_periods spcp1
    INNER JOIN (
        SELECT admissionId, MAX(id) AS maxId
        FROM student_print_certificate_periods
        GROUP BY admissionId
    ) latest ON spcp1.id = latest.maxId
) spcp ON spcp.periodId = period.id AND spcp.admissionId = adm.id',

sqlWhereQueryDef = 'WHERE (
        spcp.periodId IS NOT NULL 
        AND std.userId = PRM_STUDENT_ID  
        AND period.id = spcp.periodId
    )
    OR (
        spcp.periodId IS NULL 
        AND std.userId = PRM_STUDENT_ID
        AND pbs.isCurrentPeriod = TRUE 
        AND pbs.isCurrentSection = TRUE 
        AND pbs.isPeriodCompleted = FALSE 
        AND pbs.exitDate IS NULL
    )
GROUP BY std.userId',

resultColumnsDef = ('period_name,batch_name')
            where dataProviderId = @dydtdataproviderId;
    END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250626144653__Update_STd_Acad_TENUER_INFO_update_details () $$
DROP PROCEDURE IF EXISTS V20250626144653__Update_STd_Acad_TENUER_INFO_update_details $$
DELIMITER ;