DELIMITER $$
DROP PROCEDURE IF EXISTS V20250715174503__Update_ApplicationDetailsDataGrid $$
CREATE PROCEDURE V20250715174503__Update_ApplicationDetailsDataGrid()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM data_grid WHERE gridName='Academia.view.admission.applicationFormSale.AddProgramTabGrid' AND portalId=1)) THEN 
UPDATE `data_grid` SET `jsonObject`='[
    {
        "id": null,
        "columnName": "ACADEMY",
        "dataIndex": "academy.value",
        "columnVisibility": "SHOW",
        "sequence": 1,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "LOCATION",
        "dataIndex": "location.value",
        "columnVisibility": "SHOW",
        "sequence": 2,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "PROGRAM",
        "dataIndex": "program.value",
        "columnVisibility": "SHOW",
        "sequence": 3,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "BATCH",
        "dataIndex": "batch.value",
        "columnVisibility": "SHOW",
        "sequence": 4,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "SEAT_TYPE",
        "dataIndex": "seatType.value",
        "columnVisibility": "SHOW",
        "sequence": 5,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "MODE_OF_DELIVERY",
        "dataIndex": "deliveryMode",
        "columnVisibility": "HIDE",
        "sequence": 6,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "REGISTRATION_TYPE",
        "dataIndex": "registrationType",
        "columnVisibility": "HIDE",
        "sequence": 7,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "DISTANCE_TO_TRAVEL",
        "dataIndex": "distancetoTravel",
        "columnVisibility": "HIDE",
        "sequence": 8,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "TRANSPORT",
        "dataIndex": "whetherTransportApplicable",
        "columnVisibility": "HIDE",
        "sequence": 9,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "PRIORITY",
        "dataIndex": "priority",
        "columnVisibility": "SHOW",
        "sequence": 10,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "ACADEMIC_TERM",
        "dataIndex": "academicTerm",
        "columnVisibility": "HIDE",
        "sequence": 11,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "PROGRAM_PRIORITY",
        "dataIndex": "programPriority",
        "columnVisibility": "SHOW",
        "sequence": 12,
        "mandatory": false
    },
    {
        "id": null,
        "columnName": "ELIGIBILITY_STATUS",
        "dataIndex": "eligibilityStatus",
        "columnVisibility": "HIDE",
        "sequence": 13,
        "mandatory": false
    }
]',lastUpdate=now() WHERE `gridName`='Academia.view.admission.applicationFormSale.AddProgramTabGrid' AND portalId=1;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250715174503__Update_ApplicationDetailsDataGrid () $$
DROP PROCEDURE IF EXISTS V20250715174503__Update_ApplicationDetailsDataGrid $$
DELIMITER ;