DELIMITER $$

DROP PROCEDURE IF EXISTS V20250716191317__Delete_newFieldsInEducationHistoryDFR $$

CREATE PROCEDURE V20250716191317__Delete_newFieldsInEducationHistoryDFR()
BEGIN


    DECLARE form_field_1 BIGINT DEFAULT NULL;
    DECLARE form_field_2 BIGINT DEFAULT NULL;
      SET SQL_SAFE_UPDATES = 0;
    -- Get the ID for symbolLevelId only if it exists
    IF EXISTS (
        SELECT 1 FROM form_field_info 
        WHERE formAliasName = 'educationform' AND formFieldId = 'symbolLevelId'
    ) THEN
        SELECT id INTO form_field_1 FROM form_field_info 
        WHERE formAliasName = 'educationform' AND formFieldId = 'symbolLevelId' 
        LIMIT 1;
    END IF;

    -- Get the ID for percentageId only if it exists
    IF EXISTS (
        SELECT 1 FROM form_field_info 
        WHERE formAliasName = 'educationform' AND formFieldId = 'percentageId'
    ) THEN
        SELECT id INTO form_field_2 FROM form_field_info 
        WHERE formAliasName = 'educationform' AND formFieldId = 'percentageId' 
        LIMIT 1;
    END IF;

    -- Delete operations for form_field_1
    IF form_field_1 IS NOT NULL THEN

        IF EXISTS (
            SELECT 1 FROM form_field_helptext_lang_translation 
            WHERE formFieldDisplaySettingsId IN (
                SELECT id FROM form_field_display_settings WHERE formFieldInfoId = form_field_1
            )
        ) THEN
            DELETE FROM form_field_helptext_lang_translation 
            WHERE formFieldDisplaySettingsId IN (
                SELECT id FROM form_field_display_settings WHERE formFieldInfoId = form_field_1
            );
        END IF;

        IF EXISTS (
            SELECT 1 FROM form_field_display_settings WHERE formFieldInfoId = form_field_1
        ) THEN
            DELETE FROM form_field_display_settings WHERE formFieldInfoId = form_field_1;
        END IF;

        DELETE FROM form_field_info WHERE id = form_field_1;

    END IF;

    -- Delete operations for form_field_2
    IF form_field_2 IS NOT NULL THEN

        IF EXISTS (
            SELECT 1 FROM form_field_helptext_lang_translation 
            WHERE formFieldDisplaySettingsId IN (
                SELECT id FROM form_field_display_settings WHERE formFieldInfoId = form_field_2
            )
        ) THEN
            DELETE FROM form_field_helptext_lang_translation 
            WHERE formFieldDisplaySettingsId IN (
                SELECT id FROM form_field_display_settings WHERE formFieldInfoId = form_field_2
            );
        END IF;

        IF EXISTS (
            SELECT 1 FROM form_field_display_settings WHERE formFieldInfoId = form_field_2
        ) THEN
            DELETE FROM form_field_display_settings WHERE formFieldInfoId = form_field_2;
        END IF;

        DELETE FROM form_field_info WHERE id = form_field_2;
SET SQL_SAFE_UPDATES = 1;
    END IF;

END $$

CALL V20250716191317__Delete_newFieldsInEducationHistoryDFR() $$

DROP PROCEDURE IF EXISTS V20250716191317__Delete_newFieldsInEducationHistoryDFR $$

DELIMITER ;
