DELIMITER $$
DROP PROCEDURE IF EXISTS V20250719080959__Create_AppTrnsCreditCom $$
CREATE PROCEDURE V20250719080959__Create_AppTrnsCreditCom()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_transfer_credit_completion')) THEN 
CREATE TABLE `applicant_transfer_credit_completion` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `applicantId` BIGINT NOT NULL,
  `programId` BIGINT NOT NULL,
  `programBatchId` BIGINT NOT NULL,
  `programDuration` INT NULL DEFAULT NULL,
  `exemptedCredit` FLOAT NULL DEFAULT '0',
  `expectedCompletionDate` TIMESTAMP NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_app_trs_credit_com_applicantId_idx` (`applicantId` ASC),
  INDEX `fk_app_trs_credit_com_programId_idx` (`programId` ASC),
  INDEX `fk_app_trs_credit_com_batchId_idx` (`programBatchId` ASC),
  CONSTRAINT `fk_app_trs_credit_com_applicantId`
    FOREIGN KEY (`applicantId`)
    REFERENCES `application` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_app_trs_credit_com_programId`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_app_trs_credit_com_batchId`
    FOREIGN KEY (`programBatchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20250719080959__Create_AppTrnsCreditCom () $$ 
DROP PROCEDURE IF EXISTS V20250719080959__Create_AppTrnsCreditCom $$ 
DELIMITER ;