DELIMITER $$
DROP PROCEDURE IF EXISTS getSAGECancelledInvoiceData $$
CREATE PROCEDURE `getSAGECancelledInvoiceData` (
    IN academyLocationId BIGINT,
    IN studentCode varchar(25),
    IN cancellationFromDate DATE,
    IN cancellationToDate DATE,
    IN creationFromDate DATE,
    IN creationToDate DATE,
    IN lastUpdatedFromDate DATE,
    IN lastUpdatedToDate DATE
)
BEGIN
    SELECT 
        Date(bh.cancellationDate) AS `reversalDate`,
        bh.raiseBillType AS `type`,
        bh.billNo AS `reference`,
        bh.cancellationNarration AS `description`,
		SUM(bfprs.billableAmount) AS `reversalAmount`,
		c.currencyCode as `currencyCodes`,
        u.code AS `studentAccountNumber`,
        bh.billStatus AS `status`,
        DATE(bh.creationDateTime) AS `createdDate`,
        DATE(bh.lastUpdate) AS `updatedDate`
    FROM bill_header bh
    LEFT JOIN users u ON bh.studentId = u.id
    LEFT JOIN academy_location al ON bh.academyLocationId = al.id
    LEFT JOIN bill_fee_plan_rule_stage bfprs ON bh.id = bfprs.billId
    LEFT JOIN fee_stage_head_config fshc ON bfprs.feeStageHeadConfigId = fshc.id
    LEFT JOIN cost_centre cc ON fshc.costCentreId = cc.id
	LEFT JOIN currency c ON bh.currencyId = c.id
    WHERE bh.billStatus = 'CANCELLED' AND bh.raiseBillCategory = 'BILL_RECEIVABLE' AND bfprs.billableAmount > 0
      AND (academyLocationId IS NULL OR al.id = academyLocationId)
      AND (studentCode IS NULL OR u.code = studentCode)
      AND (cancellationFromDate IS NULL OR Date(bh.cancellationDate) >= cancellationFromDate)
      AND (cancellationToDate IS NULL OR Date(bh.cancellationDate) <= cancellationToDate)
      AND (creationFromDate IS NULL OR DATE(bh.creationDateTime) >= creationFromDate)
      AND (creationToDate IS NULL OR DATE(bh.creationDateTime) <= creationToDate)
      AND (lastUpdatedFromDate IS NULL OR DATE(bh.lastUpdate) >= lastUpdatedFromDate)
      AND (lastUpdatedToDate IS NULL OR DATE(bh.lastUpdate) <= lastUpdatedToDate)
    GROUP BY bh.id;
END$$

DELIMITER ;