DELIMITER $$
DROP PROCEDURE IF EXISTS V20250825162207__Update_VGUliveDataProvider $$
CREATE PROCEDURE V20250825162207__Update_VGUliveDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF NOT EXISTS ((select id from dydt_data_line_item where dataSourceCode="APPLICATION_INFO" and whereClauseBindingDef="PRM_APPLICATION_ID" and whetherPrimaryDataSource=1)) THEN 
UPDATE dydt_data_line_item 
SET 
    `sqlSelectQueryDef` = 'SELECT 
        ap.firstName AS applicant_firstname,
        ap.lastName AS applicant_lastname,
        ap.middleName AS applicant_middlename,
        ap.gender AS applicant_gender,
        ap.printName AS applicant_printname,
        a.code as application_code,
        s.salutationName as applicant_salutation,
        ap.birthDate as birth_date,
        ap.photoUrl as app_photo_url,
        ahr.whetherHostelApplicable as Hostel_Applicable,
        ml.itemValue as correspondance_language,
        ca.itemValue as current_activity,
        s.salutationNameInOtherLanguage AS applicant_salutation_otr_lang,
        ap.nationalID AS ap_nationalID,
        COALESCE(acd_sub.additionalCondition, \'\') AS applicationAdmissionCondition,
        COALESCE(ac.itemValue, \'\') AS additionalCondition,
        COALESCE(apss.effectiveStageMarkWithWeightage, \'\') AS effectiveStageMarkWithWeightage,
        
        -- Pivot Core Test and Subject Test marks
        MAX(CASE WHEN ssepw.evaluationParameter = \'Core Test\' THEN apsm.marksObtained END) AS CoreTestMarks,
        MAX(CASE WHEN ssepw.evaluationParameter = \'Subject Test\' THEN apsm.marksObtained END) AS SubjectTestMarks,
        
        psss_first.qualification_name as qualification_name_and_score,
        it.institute as institute_qualification_name
    
    FROM application a
    LEFT JOIN application_program aps 
           ON aps.applicationId = a.id
    LEFT JOIN applicant_person ap 
           ON a.applicantPersonId = ap.id
    LEFT JOIN applicant_hostel_requirement ahr 
           ON ahr.applicantPersonId = ap.id
    LEFT JOIN salutations s 
           ON ap.salutationId = s.id
    LEFT JOIN current_activity ca 
           ON ca.id = ap.current_activity_id
    LEFT JOIN multi_language ml 
           ON ml.id = ap.correspondence_language
    
    -- app_program_adm_details subquery (take MAX id per applicationProgramId)
    LEFT JOIN (
           SELECT apad1.*
           FROM app_program_adm_details apad1
           WHERE apad1.id = (
               SELECT MAX(apad2.id)
               FROM app_program_adm_details apad2
               WHERE apad2.applicationProgramId = apad1.applicationProgramId
           )
    ) apad 
           ON apad.applicationProgramId = aps.id
    
    -- admission_condition_detail subquery (take MIN id per appProgramAdmDetailsId)
    LEFT JOIN (
           SELECT acd1.*
           FROM admission_condition_detail acd1
           WHERE acd1.id = (
               SELECT MIN(acd2.id)
               FROM admission_condition_detail acd2
               WHERE acd2.appProgramAdmDetailsId = acd1.appProgramAdmDetailsId
           )
    ) acd_sub 
           ON acd_sub.appProgramAdmDetailsId = apad.id
    
    LEFT JOIN admission_condition ac 
           ON ac.id = acd_sub.admissionConditionId
    LEFT JOIN application_prog_stage apss 
           ON apss.applicationProgramId = aps.id
    LEFT JOIN application_prog_stage_marks apsm 
           ON apsm.applicationProgramStageId = apss.id
    LEFT JOIN slctn_stage_eval_prm_weightage ssepw 
           ON ssepw.id = apsm.evaluationParameterWeightageId
    
    -- post_school_studies_section subquery (take MIN id per applicant_person)
    LEFT JOIN (
           SELECT psss1.*
           FROM post_school_studies_section psss1
           WHERE psss1.id = (
               SELECT MIN(psss2.id)
               FROM post_school_studies_section psss2
               WHERE psss2.applicant_person_id = psss1.applicant_person_id
           )
    ) psss_first 
           ON psss_first.applicant_person_id = ap.id
    LEFT JOIN institute_type it 
           ON it.id = psss_first.institution_name_id',
    `resultColumnsDef` = 'applicant_firstname,applicant_lastname,applicant_middlename,applicant_gender,applicant_printname,application_code,applicant_salutation,birth_date,app_photo_url,Hostel_Applicable,correspondance_language,current_activity,applicant_salutation_otr_lang,ap_nationalID,additionalCondition,applicationAdmissionCondition,effectiveStageMarkWithWeightage,SubjectTestMarks,CoreTestMarks,institute_qualification_name,qualification_name_and_score'
WHERE
    dataSourceCode = 'APPLICATION_INFO'
        AND whereClauseBindingDef = 'PRM_APPLICATION_ID'
        AND whetherPrimaryDataSource = 1;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250825162207__Update_VGUliveDataProvider () $$
DROP PROCEDURE IF EXISTS V20250825162207__Update_VGUliveDataProvider $$
DELIMITER ;