DELIMITER $$
DROP PROCEDURE IF EXISTS V20250926100453__Create_BothoGraduationCertificateReport $$
CREATE PROCEDURE V20250926100453__Create_BothoGraduationCertificateReport()
BEGIN


set @reportTypeTempId = (select max(id) from report_type where typeName='Basic Reports');

IF NOT EXISTS(select * from report_template where templateCode = 'BOTHO_GRADUATION_CERTIFICATE') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`,  `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'BOTHO_GRADUATION_CERTIFICATE', 'Botho Graduation Certificate', 'BOTHO_GRADUATION_CERTIFICATE.png', 'BOTHO_GRADUATION_CERTIFICATE.jasper', 'All',  '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'BOTHO_GRADUATION_CERTIFICATE.jasper', 'AcademiaLogo.png');
END IF; 	

set @tempId = (select max(id) from report_template where templateCode='BOTHO_GRADUATION_CERTIFICATE');


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_HEREBY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_HEREBY', 'hereby confers upon', '1', now());
END IF; 


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_QUALIFICATION') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_QUALIFICATION', 'the qualification of', '1', now());
END IF; 


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CLASSIFICATION') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CLASSIFICATION', 'Classification', '1', now());
END IF; 


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CONFERRED_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CONFERRED_DATE', 'Conferred Date', '1', now());
END IF; 



IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STUDENT_ID') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STUDENT_ID', 'Student Id', '1', now());
END IF; 



IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CERTIFICATE_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CERTIFICATE_NO', 'Certificate No', '1', now());
END IF; 



END $$
CALL V20250926100453__Create_BothoGraduationCertificateReport () $$ 
DROP PROCEDURE IF EXISTS V20250926100453__Create_BothoGraduationCertificateReport $$ 
DELIMITER ;