DELIMITER $$
DROP PROCEDURE IF EXISTS V20250929170224__Alter_GradeTypeForSecondGradeCSM $$
CREATE PROCEDURE V20250929170224__Alter_GradeTypeForSecondGradeCSM()
BEGIN
    DECLARE currentTimeStamp DATETIME;
    SET currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
    -- Insert into standard_master_items if not exists
    IF NOT EXISTS (
        SELECT 1 
        FROM standard_master_items 
        WHERE dbFieldName = 'whetherSecondaryGrade'
    ) THEN
        INSERT INTO standard_master_items 
        (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,
         `diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,
         `whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`)
        VALUES
        ('whetherSecondaryGrade','WHETHER_SECONDARY_GRADE',
         (SELECT MAX(id) FROM standard_master WHERE tableName='grade_type'),
         'Boolean',NULL,3,0,NULL,NULL,NULL,0,0,0,1,currentTimeStamp);
    END IF;
    -- Add column whetherSecondaryGrade if not exists
    IF NOT EXISTS (
        SELECT * 
        FROM information_schema.columns 
        WHERE table_schema = DATABASE() 
          AND table_name = 'grade_type' 
          AND column_name = 'whetherSecondaryGrade'
    ) THEN
        ALTER TABLE `grade_type` 
        ADD COLUMN `whetherSecondaryGrade` BIT(1) NOT NULL DEFAULT b'0' 
        AFTER `whetherSpecialGrade`;
    END IF;
    -- Insert into ui_translation if not exists
    IF NOT EXISTS (
        SELECT 1 
        FROM ui_translation 
        WHERE objectName = 'masterNames' 
          AND keyName = 'WHETHER_SECONDARY_GRADE'
    ) THEN
        INSERT INTO `ui_translation` 
        (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
        VALUES 
        ('masterNames','WHETHER_SECONDARY_GRADE','Whether Secondary Grade','Whether Secondary Grade',currentTimeStamp,1);
    END IF;
END $$
CALL V20250929170224__Alter_GradeTypeForSecondGradeCSM() $$
DROP PROCEDURE IF EXISTS V20250929170224__Alter_GradeTypeForSecondGradeCSM $$
DELIMITER ;