DELIMITER $$
DROP PROCEDURE IF EXISTS V20251009112749__Create_Student_Al_Transfer_Confermation $$
CREATE PROCEDURE V20251009112749__Create_Student_Al_Transfer_Confermation()
BEGIN

 IF NOT EXISTS (SELECT * FROM system_msg_event WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION' LIMIT 1) THEN
        SET @msgcategoryId = (SELECT MAX(id) FROM msg_category);
        SET @parentcategoryId = (SELECT id FROM msg_category WHERE `code`='FEE_PAYMENT');
        IF NOT EXISTS (SELECT * FROM msg_category WHERE `code`='STUDENT_AL_TRANSFER_CONFIRMATION' AND parentCategory=@parentcategoryId LIMIT 1) THEN
            INSERT INTO `msg_category` (`id`, `parentCategory`, `code`) 
            VALUES (@msgcategoryId+2, @parentcategoryId, 'STUDENT_AL_TRANSFER_CONFIRMATION');
        END IF;

        SET @systemmsgeventId = (SELECT MAX(id) FROM system_msg_event);
        SET @msgSubCategoryId = (SELECT id FROM msg_category WHERE `code`='STUDENT_AL_TRANSFER_CONFIRMATION');

        IF NOT EXISTS (SELECT * FROM system_msg_event WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION') THEN
            INSERT INTO `system_msg_event`
            (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
            VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION', 'Academy Location Transfer confirmation', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION');
        END IF;

        SET @sysmsgevtdefaultconfId = (SELECT MAX(id) FROM sys_msg_evt_default_conf);
        IF NOT EXISTS (SELECT * FROM sys_msg_evt_default_conf WHERE `systemMsgEventId`=@systemmsgeventId+1) THEN
            INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
            VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
        END IF;

        SET @sysmsgevtdefaultscopeId = (SELECT MAX(id) FROM sys_msg_evt_default_scope);
        SET @msgScopeParamId = (SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
        IF NOT EXISTS (SELECT * FROM sys_msg_evt_default_scope WHERE `sysMsgEvtDefaultCnfgId`=@sysmsgevtdefaultconfId+1 AND `msgScopeParamId`=@msgScopeParamId) THEN
            INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) 
            VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
        END IF;

        SET @sysmsgevtdefaultscopeId = (SELECT MAX(id) FROM sys_msg_evt_default_scope);
        SET @msgScopeParamId = (SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
        IF NOT EXISTS (SELECT * FROM sys_msg_evt_default_scope WHERE `sysMsgEvtDefaultCnfgId`=@sysmsgevtdefaultconfId+1 AND `msgScopeParamId`=@msgScopeParamId) THEN
            INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) 
            VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
        END IF;

        SET @sysmsgevtdefaultscopeId = (SELECT MAX(id) FROM sys_msg_evt_default_scope);
        SET @msgScopeParamId = (SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
        IF NOT EXISTS (SELECT * FROM sys_msg_evt_default_scope WHERE `sysMsgEvtDefaultCnfgId`=@sysmsgevtdefaultconfId+1 AND `msgScopeParamId`=@msgScopeParamId) THEN
            INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) 
            VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
        END IF;

        SET @sysmsgevtdefaultscopeId = (SELECT MAX(id) FROM sys_msg_evt_default_scope);
        SET @msgScopeParamId = (SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
        IF NOT EXISTS (SELECT * FROM sys_msg_evt_default_scope WHERE `sysMsgEvtDefaultCnfgId`=@sysmsgevtdefaultconfId+1 AND `msgScopeParamId`=@msgScopeParamId) THEN
            INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) 
            VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
        END IF;

        -- DL data provider
        SET @dtproviderId = (SELECT MAX(id) FROM dtprovider);
        IF NOT EXISTS (SELECT * FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_DL') THEN
            INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) 
            VALUES (@dtproviderId+1, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_DL', 'SQL');
        END IF;
        IF NOT EXISTS (SELECT * FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_DL') THEN
            INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) 
            VALUES (@dtproviderId+2, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_DL', 'SQL');
        END IF;
        IF NOT EXISTS (SELECT * FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_DL') THEN
            INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) 
            VALUES (@dtproviderId+3, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_DL', 'SQL');
        END IF;

        -- Recipient Info data provider
        SET @dtproviderId = (SELECT MAX(id) FROM dtprovider);
        IF NOT EXISTS (SELECT * FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_RCPNT') THEN
            INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) 
            VALUES (@dtproviderId+1, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_RCPNT', 'SQL');
        END IF;
        IF NOT EXISTS (SELECT * FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT') THEN
            INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) 
            VALUES (@dtproviderId+2, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT', 'SQL');
        END IF;
        IF NOT EXISTS (SELECT * FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT') THEN
            INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) 
            VALUES (@dtproviderId+3, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT', 'SQL');
        END IF;

        SET @msgRecipientId = (SELECT MAX(id) FROM msg_recipient_type);
        SET @paret1 = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_RCPNT');
        SET @paret2 = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT');
        SET @feepayer = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT');
        IF NOT EXISTS (SELECT * FROM msg_recipient_type WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_RCPNT') THEN
            INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) 
            VALUES (@msgRecipientId+1, @paret1, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_RCPNT');
        END IF;
        IF NOT EXISTS (SELECT * FROM msg_recipient_type WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT') THEN
            INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) 
            VALUES (@msgRecipientId+2, @paret2, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT');
        END IF;
        IF NOT EXISTS (SELECT * FROM msg_recipient_type WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT') THEN
            INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) 
            VALUES (@msgRecipientId+3, @feepayer, 'ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT');
        END IF;

        -- The under sql code gives for the user distribution list, this information can be fetched
        SET @sysmsgevtrcptdefaultconfId = (SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
        SET @paret1 = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_DL');
        SET @paret2 = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_DL');
        SET @feepayer = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_DL');
        SET @studentparet1 = (SELECT id FROM `msg_recipient_type` WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_RCPNT');
        SET @studentparet2 = (SELECT id FROM `msg_recipient_type` WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT');
        SET @studentfeepayer = (SELECT id FROM `msg_recipient_type` WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT');
        IF NOT EXISTS (SELECT * FROM `sys_msg_evtrcpt_default_conf` WHERE `sysMsgEvtDefaultConfId`=@sysmsgevtdefaultconfId+1 AND `distrListProviderId`=@paret1 AND `recipientTypeId`=@studentparet1) THEN
            INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
            VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @paret1, NULL, @studentparet1);
        END IF;
        IF NOT EXISTS (SELECT * FROM `sys_msg_evtrcpt_default_conf` WHERE `sysMsgEvtDefaultConfId`=@sysmsgevtdefaultconfId+1 AND `distrListProviderId`=@paret2 AND `recipientTypeId`=@studentparet2) THEN
            INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
            VALUES (@sysmsgevtrcptdefaultconfId+2, @sysmsgevtdefaultconfId+1, @paret2, NULL, @studentparet2);
        END IF;
        IF NOT EXISTS (SELECT * FROM `sys_msg_evtrcpt_default_conf` WHERE `sysMsgEvtDefaultConfId`=@sysmsgevtdefaultconfId+1 AND `distrListProviderId`=@feepayer AND `recipientTypeId`=@studentfeepayer) THEN
            INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
            VALUES (@sysmsgevtrcptdefaultconfId+3, @sysmsgevtdefaultconfId+1, @feepayer, NULL, @studentfeepayer);
        END IF;

        -- Setting the query for the Parent distribution list
        SET @sqlDtproviderId = (SELECT MAX(id) FROM `sql_dtprovider`);
        SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_DL');
        IF NOT EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId`=@dtproviderId) THEN
            INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) 
            VALUES (@sqlDtproviderId+1, @dtproviderId,
                "SELECT   
                    T1.id AS USER_ID
                FROM
                    users T1
                    LEFT JOIN person_relationships T2 ON T2.personId=T1.id
                    LEFT JOIN persons T3 ON T3.id=T2.relatedPersonId
                WHERE
                    T1.id IN (namedParams) AND T2.relationship='FATHER'", NULL);
        END IF;

        SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_DL');
        IF NOT EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId`=@dtproviderId) THEN
            INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) 
            VALUES (@sqlDtproviderId+2, @dtproviderId,
                "SELECT   
                    T1.id AS USER_ID
                FROM
                    users T1
                    LEFT JOIN person_relationships T2 ON T2.personId=T1.id
                    LEFT JOIN persons T3 ON T3.id=T2.relatedPersonId
                WHERE
                    T1.id IN (namedParams) AND T2.relationship='MOTHER'", NULL);
        END IF;

        SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_DL');
        IF NOT EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId`=@dtproviderId) THEN
            INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) 
            VALUES (@sqlDtproviderId+3, @dtproviderId,
                "SELECT   
                    T1.id AS USER_ID
                FROM
                    users T1
                    LEFT JOIN students T4 ON T4.userId = T1.id
                    LEFT JOIN persons T3 ON T3.id = T4.personId
                    LEFT JOIN fee_payer_detail T2 ON T2.personId=T3.id
                WHERE
                    T1.id IN (namedParams) AND T2.isPrimaryFeePayer=true", NULL);
        END IF;

        SET @sqlDtproviderId = (SELECT MAX(id) FROM `sql_dtprovider`);
        SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_RCPNT');
        IF NOT EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId`=@dtproviderId) THEN
            INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) 
            VALUES (@sqlDtproviderId+1, @dtproviderId,
                "SELECT 
                    T1.userId AS ID, 
                    T9.`displayName` AS ACADEMY_NAME
                FROM
                    students T1
                    LEFT JOIN users T8 ON T1.userId = T8.id
                    LEFT JOIN persons T3 ON T3.id = T1.personId
                    LEFT JOIN admission a ON a.studentId = T8.id
                    LEFT JOIN student_transfer_request_details STRD ON STRD.fromAdmissionId = a.id
                    LEFT JOIN academy_location T9 ON T9.id = STRD.fromALId
                    LEFT JOIN person_relationships T5 ON T3.id = T5.personId
                    LEFT JOIN persons T7 ON T5.relatedPersonId = T7.id
                WHERE
                    T1.userId IN (namedParams)
                    AND T5.relationship = 'FATHER'
                    AND T5.whetherDeleted = FALSE
                GROUP BY T1.userId;",
                '{
                    "id": 1,
                    "searchResultViewColumns": [
                        {
                            "id": 1,
                            "value": "ACADEMYNAME",
                            "resultKey": "ACADEMY_NAME",
                            "displayCode": "",
                            "displayOrder": 0
                        }
                    ]
                }');
        END IF;

        SET @sqlDtproviderId = (SELECT MAX(id) FROM `sql_dtprovider`);
        SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT');
        IF NOT EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId`=@dtproviderId) THEN
            INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) 
            VALUES (@sqlDtproviderId+1, @dtproviderId,
                "SELECT 
                    T1.userId AS ID, T9.`displayName` AS ACADEMY_NAME
                FROM
                    students T1
                    LEFT JOIN users T8 ON T1.userId = T8.id
                    LEFT JOIN persons T3 ON T3.id = T1.personId
                    LEFT JOIN admission a ON a.studentId = T8.id
                    LEFT JOIN student_transfer_request_details STRD ON STRD.fromAdmissionId = a.id
                    LEFT JOIN academy_location T9 ON T9.id = STRD.fromALId
                    LEFT JOIN person_relationships T5 ON T3.id = T5.personId
                    LEFT JOIN persons T7 ON T5.relatedPersonId = T7.id
                WHERE
                    T1.userId IN (namedParams)
                    AND T5.relationship = 'MOTHER'
                    AND T5.whetherDeleted = FALSE
                GROUP BY T1.userId;",
                '{
                    "id": 1,
                    "searchResultViewColumns": [
                        {
                            "id": 1,
                            "value": "ACADEMYNAME",
                            "resultKey": "ACADEMY_NAME",
                            "displayCode": "",
                            "displayOrder": 0
                        }
                    ]
                }');
        END IF;

        SET @sqlDtproviderId = (SELECT MAX(id) FROM `sql_dtprovider`);
        SET @dtproviderId = (SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT');
        IF NOT EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId`=@dtproviderId) THEN
            INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) 
            VALUES (@sqlDtproviderId+1, @dtproviderId,
                "SELECT 
                    T1.userId AS ID, T9.`displayName` AS ACADEMY_NAME
                FROM
                    students T1
                    LEFT JOIN users T8 ON T1.userId = T8.id
                    LEFT JOIN persons T3 ON T3.id = T1.personId
                    LEFT JOIN admission a ON a.studentId = T8.id
                    LEFT JOIN student_transfer_request_details STRD ON STRD.fromAdmissionId = a.id
                    LEFT JOIN academy_location T9 ON T9.id = STRD.fromALId
                    LEFT JOIN fee_payer_detail fpd ON fpd.personId = T3.id
                WHERE
                    T1.userId IN (namedParams) AND 
                    fpd.isPrimaryFeePayer = true
                GROUP BY T1.userId",
                '{
                    "id": 1,
                    "searchResultViewColumns": [
                        {
                            "id": 1,
                            "value": "ACADEMYNAME",
                            "resultKey": "ACADEMY_NAME",
                            "displayCode": "",
                            "displayOrder": 0
                        }
                    ]
                }');
        END IF;

        SET @msgtemplateId = (SELECT MAX(id) FROM msg_template);
        SET @sysMsgEventId = (SELECT id FROM system_msg_event WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION');
        SET @msgtemplateconfigId = (SELECT MAX(id) FROM msg_template_config);
        SET @msgSubCategoryId = (SELECT id FROM `msg_category` WHERE `code`='STUDENT_AL_TRANSFER_CONFIRMATION');
        SET @recipientTypeId = (SELECT id FROM `msg_recipient_type` WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT1_RCPNT');
        SET @msgMessageTypeId = (SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

        IF NOT EXISTS (SELECT * FROM `msg_template_config` WHERE `code`='Academy Location Transfer Confirmation Parent 1' AND `recipientTypeId`=@recipientTypeId) THEN
            INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`, `whetherEnabled`)
            VALUES (@msgtemplateconfigId+1, 'Academy Location Transfer Confirmation Parent 1', @msgSubCategoryId, @sysMsgEventId, @recipientTypeId, @msgMessageTypeId, NULL, NULL, 'Academy Location Transfer Confirmation Parent 1', NULL, '', NULL, '', 'APPROVED', '', '1', 'System Admin System Admin', '1', b'1');
        END IF;

        SET @msgtemplateId = (SELECT MAX(id) FROM msg_template);
        IF NOT EXISTS (SELECT * FROM msg_template WHERE `msgTemplateConfigId`=@msgtemplateconfigId+1 AND `msgDeliveryModeId`='1') THEN
            INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
            VALUES (@msgtemplateId+1, @msgtemplateconfigId+1, '1', 'Academy Location Transfer', 
                '<html>
<head>
	<title></title>
</head>
<body data-gr-ext-installed="" data-new-gr-c-s-check-loaded="14.1229.0" data-new-gr-c-s-loaded="14.1229.0">
<p><span font-family:="">&ldquo;Dear Parent, We are pleased to inform you that your request to transfer your child has been successfully processed. Please complete the online registration for the new school through the Parent Portal. Once registration is finalised, your child will be allocated to a class. If you have any questions or need assistance, feel free to contact us. Kind regards &lt;School B name&gt;</span></p>
</body>
</html>');
        END IF;

        IF NOT EXISTS (SELECT * FROM msg_template WHERE `msgTemplateConfigId`=@msgtemplateconfigId+1 AND `msgDeliveryModeId`='2') THEN
            INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
            VALUES (@msgtemplateId+2, @msgtemplateconfigId+1, '2', NULL, NULL);
        END IF;

        IF NOT EXISTS (SELECT * FROM msg_template WHERE `msgTemplateConfigId`=@msgtemplateconfigId+1 AND `msgDeliveryModeId`='6') THEN
            INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
            VALUES (@msgtemplateId+3, @msgtemplateconfigId+1, '6', NULL, NULL);
        END IF;

        SET @msgtemplateId = (SELECT MAX(id) FROM msg_template);
        SET @msgtemplateconfigId = (SELECT MAX(id) FROM msg_template_config);
        SET @recipientTypeId = (SELECT id FROM `msg_recipient_type` WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_PARENT2_RCPNT');
        SET @msgMessageTypeId = (SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

        IF NOT EXISTS (SELECT * FROM `msg_template_config` WHERE `code`='Academy Location Transfer Confirmation Parent 2' AND `recipientTypeId`=@recipientTypeId) THEN
            INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`, `whetherEnabled`)
            VALUES (@msgtemplateconfigId+1, 'Academy Location Transfer Confirmation Parent 2', @msgSubCategoryId, @sysMsgEventId, @recipientTypeId, @msgMessageTypeId, NULL, NULL, 'Academy Location Transfer Confirmation Parent 2', NULL, '', NULL, '', 'APPROVED', '', '1', 'System Admin System Admin', '1', b'1');
        END IF;

        SET @msgtemplateId = (SELECT MAX(id) FROM msg_template);
        IF NOT EXISTS (SELECT * FROM msg_template WHERE `msgTemplateConfigId`=@msgtemplateconfigId+1 AND `msgDeliveryModeId`='1') THEN
            INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
            VALUES (@msgtemplateId+1, @msgtemplateconfigId+1, '1', 'Academy Location Transfer', 
                '<html>
<head>
	<title></title>
</head>
<body data-gr-ext-installed="" data-new-gr-c-s-check-loaded="14.1229.0" data-new-gr-c-s-loaded="14.1229.0">
<p><span font-family:="">&ldquo;Dear Parent, We are pleased to inform you that your request to transfer your child has been successfully processed. Please complete the online registration for the new school through the Parent Portal. Once registration is finalised, your child will be allocated to a class. If you have any questions or need assistance, feel free to contact us. Kind regards &lt;School B name&gt;</span></p>
</body>
</html>');
        END IF;

        IF NOT EXISTS (SELECT * FROM msg_template WHERE `msgTemplateConfigId`=@msgtemplateconfigId+1 AND `msgDeliveryModeId`='2') THEN
            INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
            VALUES (@msgtemplateId+2, @msgtemplateconfigId+1, '2', NULL, NULL);
        END IF;

        IF NOT EXISTS (SELECT * FROM msg_template WHERE `msgTemplateConfigId`=@msgtemplateconfigId+1 AND `msgDeliveryModeId`='6') THEN
            INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
            VALUES (@msgtemplateId+3, @msgtemplateconfigId+1, '6', NULL, NULL);
        END IF;

        SET @msgtemplateId = (SELECT MAX(id) FROM msg_template);
        SET @msgtemplateconfigId = (SELECT MAX(id) FROM msg_template_config);
        SET @recipientTypeId = (SELECT id FROM `msg_recipient_type` WHERE `code`='ACADEMY_LOCATION_TRANSFER_CONFIRMATION_FEEPAYER_RCPNT');
        SET @msgMessageTypeId = (SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

        IF NOT EXISTS (SELECT * FROM `msg_template_config` WHERE `code`='Academy Location Transfer Confirmation FeepPayer' AND `recipientTypeId`=@recipientTypeId) THEN
            INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`, `whetherEnabled`)
            VALUES (@msgtemplateconfigId+1, 'Academy Location Transfer Confirmation FeepPayer', @msgSubCategoryId, @sysMsgEventId, @recipientTypeId, @msgMessageTypeId, NULL, NULL, 'Academy Location Transfer Confirmation FeepPayer', NULL, '', NULL, '', 'APPROVED', '', '1', 'System Admin System Admin', '1', b'1');
        END IF;

        SET @msgtemplateId = (SELECT MAX(id) FROM msg_template);
        IF NOT EXISTS (SELECT * FROM msg_template WHERE `msgTemplateConfigId`=@msgtemplateconfigId+1 AND `msgDeliveryModeId`='1') THEN
            INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
            VALUES (@msgtemplateId+1, @msgtemplateconfigId+1, '1', 'Academy Location Transfer', 
                '<html>
<head>
	<title></title>
</head>
<body data-gr-ext-installed="" data-new-gr-c-s-check-loaded="14.1229.0" data-new-gr-c-s-loaded="14.1229.0">
<p><span font-family:="">&ldquo;Dear Parent, We are pleased to inform you that your request to transfer your child has been successfully processed. Please complete the online registration for the new school through the Parent Portal. Once registration is finalised, your child will be allocated to a class. If you have any questions or need assistance, feel free to contact us. Kind regards &lt;School B name&gt;</span></p>
</body>
</html>');
        END IF;

        IF NOT EXISTS (SELECT * FROM msg_template WHERE `msgTemplateConfigId`=@msgtemplateconfigId+1 AND `msgDeliveryModeId`='2') THEN
            INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
            VALUES (@msgtemplateId+2, @msgtemplateconfigId+1, '2', NULL, NULL);
        END IF;

        IF NOT EXISTS (SELECT * FROM msg_template WHERE `msgTemplateConfigId`=@msgtemplateconfigId+1 AND `msgDeliveryModeId`='6') THEN
            INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
            VALUES (@msgtemplateId+3, @msgtemplateconfigId+1, '6', NULL, NULL);
        END IF;

        IF NOT EXISTS (SELECT * FROM `picklist_translation` WHERE `key`='STUDENT_AL_TRANSFER_CONFIRMATION') THEN
            INSERT INTO `picklist_translation` (`key`, `en`) 
            VALUES ('STUDENT_AL_TRANSFER_CONFIRMATION', 'Student Academy Location Transfer Confirmation');
        END IF;

        IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE `keyName`='ACADEMY_NAME' AND `objectName`='MESSAGING_TRANSLATIONS') THEN
            INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
            VALUES ('MESSAGING_TRANSLATIONS', 'ACADEMY_NAME', 'Academy Location Name', 'Academy Location Name', 'Akademie Ligging Naam', 'Tên địa điểm học viện', NOW(), 1);
        END IF;
    END IF;
 

END $$
CALL V20251009112749__Create_Student_Al_Transfer_Confermation () $$ 
DROP PROCEDURE IF EXISTS V20251009112749__Create_Student_Al_Transfer_Confermation $$ 
DELIMITER ;