DELIMITER $$
DROP PROCEDURE IF EXISTS V20251103113518__Update_ReportTampleAddProgramName $$
CREATE PROCEDURE V20251103113518__Update_ReportTampleAddProgramName()
BEGIN
SET SQL_SAFE_UPDATES=0;
set @dataProviderId=(SELECT id FROM dtprovider where dataProviderName='SERVICE_REQUEST_STUDENT_CREATION_RCPNT');
IF EXISTS ((SELECT id FROM sql_dtprovider WHERE dataProviderId=@dataProviderId)) THEN 
UPDATE `sql_dtprovider` SET `sqlQuery` = 'SELECT \n    T1.id AS ID,\n    T1.requestId AS REQUEST_ID,\n    T5.firstName AS FIRST_NAME,\n    T5.lastName AS LAST_NAME,\n    T5.printName AS PRINT_NAME,\n    T5.emailId AS EMAIL_ID,\n    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,\n    T5.mobileNumber AS MOBILE_NO,\n    T5.mobileCountryCode AS MOBILE_CODE,\n    T6.academyName AS ACADEMY_NAME,\n    T6.locationName AS LOCATION_NAME,\n    T6.displayName AS ACADEMY_NAME_LOCATION,\n    T2.requestType AS REQUEST_TYPE,\n    ml.code as LANGUAGE_KEY,\nT5.externalSysRefOne as STUDENT_EXTERNAL_REFERENCE_NUMBER_1,\nT1.requestDate AS REQUEST_DATE,\np.programNameToBePrint AS PROGRAM_NAME,\nFROM\n    service_requests T1\n        LEFT JOIN\n    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId\n        LEFT JOIN\n    users T3 ON T3.id = T1.requester\n        LEFT JOIN\n    students T4 ON T4.userId = T3.id\n        LEFT JOIN\n    persons T5 ON T5.id = T4.personId\n        LEFT JOIN\n    academy_location T6 ON T6.id = T2.academyLocationId\n        LEFT JOIN\n	multi_language ml on ml.id=T5.correspondence_language\n left join \n    programs p on p.id=T1.currentProgram\nWHERE\n    T1.id IN (namedParams)', `jsonString` = '{\n \"id\": 1,\n     \"searchResultViewColumns\": [\n        {\n            \"id\": 1,\n            \"value\": \"id\",\n            \"resultKey\": \"ID\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 0\n        },        \n        {\n            \"id\": 2,\n            \"value\": \"firstName\",\n            \"resultKey\": \"FIRST_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 1\n        },       \n        {\n            \"id\": 3,\n            \"value\": \"lastName\",\n            \"resultKey\": \"LAST_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 2\n        },       \n        {\n            \"id\": 4,\n            \"value\": \"printName\",\n            \"resultKey\": \"PRINT_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 3\n        },\n        {\n            \"id\": 5,\n            \"value\": \"academyName\",\n            \"resultKey\": \"ACADEMY_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 4\n        },\n		{\n            \"id\": 6,\n            \"value\": \"locationName\",\n            \"resultKey\": \"LOCATION_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 5\n        },\n		{\n            \"id\": 7,\n            \"value\": \"displayName\",\n            \"resultKey\": \"ACADEMY_NAME_LOCATION\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 6\n        },\n		{\n            \"id\": 8,\n            \"value\": \"requestType\",\n            \"resultKey\": \"REQUEST_TYPE\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 7\n        },\n		{\n            \"id\": 9,\n            \"value\": \"requestId\",\n            \"resultKey\": \"REQUEST_ID\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 8\n        },\n{\n      \"id\": 10,\n      \"value\": \"externalSysRefOne\",\n      \"resultKey\": \"STUDENT_EXTERNAL_REFERENCE_NUMBER_1\",\n      \"displayCode\": \"\",\n      \"displayOrder\": 9\n    },\n{\n            \"id\": 11,\n            \"value\": \"requestDate\",\n            \"resultKey\": \"REQUEST_DATE\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 10\n        },\n {\n            \"id\": 12,\n            \"value\": \"programNameToBePrint\",\n            \"resultKey\": \"PROGRAM_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 11\n        }\n    ]}' WHERE dataProviderId=@dataProviderId;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251103113518__Update_ReportTampleAddProgramName () $$
DROP PROCEDURE IF EXISTS V20251103113518__Update_ReportTampleAddProgramName $$
DELIMITER ;