DELIMITER $$
DROP PROCEDURE IF EXISTS V20251104125924__Update_ReceiptAcknowForApplicantSQL $$
CREATE PROCEDURE V20251104125924__Update_ReceiptAcknowForApplicantSQL()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select MAX(id) from dtprovider where dataProviderName="APPLICANT_PAYMENT_ACKNOWLEDGEMENT")) THEN
SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="APPLICANT_PAYMENT_ACKNOWLEDGEMENT");
IF EXISTS (select MAX(id) from dtprovider where dataProviderName="APPLICANT_PAYMENT_ACKNOWLEDGEMENT") THEN
update sql_dtprovider set sqlQuery="SELECT 
	RH.id as ID,
	A.code as APPLICANT_CODE,
    AP.emailId as EMAIL_ID,
    AP.alternateEmailId as ALTERNATE_EMAIL_ID,
    AP.printName AS PRINT_NAME,
    AP.firstName AS FIRST_NAME,
    AP.middleName AS MIDDLE_NAME,
    AP.lastName AS LAST_NAME,
    RH.amount AS AMOUNT,
    RH.receiptNo AS RECEIPT_NO,
    RH.transactionDate AS TRANSACTION_DATE,
    FPM.paymentModeName AS PAYMENT_MODE_NAME,
    RH.voucherMode AS VOUCHER_MODE,
    RH.receiptType AS RECEIPT_TYPE
    
    FROM 
    receipt_header RH
    LEFT JOIN application A ON A.id = RH.applicantId
    LEFT JOIN applicant_person AP ON AP.id = A.applicantPersonId
	LEFT JOIN receipt_payment_instrument RPI ON RPI.receiptHeaderId = RH.id
	LEFT JOIN fee_payment_modes FPM ON FPM.id = RPI.paymentMode
   WHERE
    RH.id IN (namedParams)"
where dataProviderId=@dtProviderId;  
END IF;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251104125924__Update_ReceiptAcknowForApplicantSQL () $$
DROP PROCEDURE IF EXISTS V20251104125924__Update_ReceiptAcknowForApplicantSQL $$
DELIMITER ;