DELIMITER $$
DROP PROCEDURE IF EXISTS netsuiteFetchCancelReceiptToBePushed $$
CREATE PROCEDURE netsuiteFetchCancelReceiptToBePushed()
BEGIN
# cancel receipt 
SELECT 
    rh.id AS id,
    rh.receiptNo AS receiptNo,
    ncrm.id AS netsuiteReceiptMappingId,
    ncrm.netsuiteReceiptId AS netsuiteReceiptId,
    nccm.id AS netsuiteCustomerMappingId,
    nccm.netsuiteCustomerId AS netsuiteCustomerId,
    nccm.academiaUserCode AS studentCode,
    ncrm.billNo AS billNo,
    ncrm.billHeaderId AS billHeaderId,
    ncrm.netsuiteInvoiceId AS netsuiteInvoiceId,
    ncrm.academiaUserId AS academiaUserId
FROM
    receipt_header rh
    inner join netsuite_create_receipt_mapping ncrm on rh.id=ncrm.receiptHeaderId
    inner join netsuite_create_customer_mapping nccm on rh.studentId=nccm.academiaUserId  
    
    where rh.status="CANCELLED" and rh.studentId is not null and ncrm.isCancelled=false
#and rh.id in (63799,63800)
GROUP BY 
    rh.id
#limit 4
;

END $$ 
DELIMITER ;