DELIMITER $$
DROP PROCEDURE IF EXISTS V20251126160139__Alter_AddParentCgINCourseGroup $$
CREATE PROCEDURE V20251126160139__Alter_AddParentCgINCourseGroup()
BEGIN

  IF EXISTS (
        SELECT 1 
        FROM information_schema.tables 
        WHERE table_name = 'course_group'
          AND table_schema = DATABASE()
    ) THEN

        
        IF NOT EXISTS (
            SELECT 1
            FROM information_schema.columns
            WHERE table_name = 'course_group'
              AND column_name = 'whetherBlockGroup'
              AND table_schema = DATABASE()
        ) THEN
            ALTER TABLE course_group 
            ADD COLUMN whetherBlockGroup TINYINT(1) NOT NULL DEFAULT 0;
        END IF;

     
        IF NOT EXISTS (
            SELECT 1
            FROM information_schema.columns
            WHERE table_name = 'course_group'
              AND column_name = 'parentCourseGroupId'
              AND table_schema = DATABASE()
        ) THEN
            ALTER TABLE course_group 
            ADD COLUMN parentCourseGroupId BIGINT NULL;
        END IF;

        
        IF NOT EXISTS (
            SELECT 1 
            FROM information_schema.table_constraints 
            WHERE constraint_name = 'fk_course_groups_parent'
              AND table_name = 'course_group'
              AND table_schema = DATABASE()
        ) THEN
            ALTER TABLE course_group
            ADD CONSTRAINT fk_course_groups_parent
                FOREIGN KEY (parentCourseGroupId)
                REFERENCES course_group(id)
                ON DELETE SET NULL
                ON UPDATE CASCADE;
        END IF;

        IF NOT EXISTS (
            SELECT 1
            FROM information_schema.statistics
            WHERE table_name = 'course_group'
              AND index_name = 'idx_course_groups_parent'
              AND table_schema = DATABASE()
        ) THEN
            CREATE INDEX idx_course_groups_parent
            ON course_group(parentCourseGroupId);
        END IF;

    END IF;

END $$
CALL V20251126160139__Alter_AddParentCgINCourseGroup() $$
DROP PROCEDURE IF EXISTS V20251126160139__Alter_AddParentCgINCourseGroup $$
DELIMITER ;