DELIMITER $$
DROP PROCEDURE IF EXISTS V20251127103906__Alter_NameToBePrintedAndTranslationCG $$
CREATE PROCEDURE V20251127103906__Alter_NameToBePrintedAndTranslationCG()
BEGIN
 IF EXISTS (
        SELECT 1 
        FROM information_schema.tables 
        WHERE table_name = 'course_group'
          AND table_schema = DATABASE()
    ) THEN
        IF NOT EXISTS (
            SELECT 1
            FROM information_schema.columns
            WHERE table_name = 'course_group'
              AND column_name = 'nameToBePrinted'
              AND table_schema = DATABASE()
        ) THEN
            ALTER TABLE course_group 
            ADD COLUMN nameToBePrinted VARCHAR(255) DEFAULT NULL;
        END IF;
    END IF;
    
     IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='COURSE_GROUP_NAME_TO_PRINTED')) THEN
	 INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
	 VALUES ('TRANSLATIONS','COURSE_GROUP_NAME_TO_PRINTED','Course Group Name To Be Printed','Course Group Name To Be Printed','Kursusgroepnaam moet gedruk word','Tên nhóm khóa học sẽ được in',now(),1);
	 END IF;
     
      IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='BLOCK_GROUP')) THEN
      INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
      VALUES ('TRANSLATIONS','BLOCK_GROUP','Block Group','Block Group','Blokgroep','Nhóm khối',now(),1);
      END IF; 
      
	  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='PARENT_COURSE_GROUP')) THEN
	  INSERT INTO ui_translation (objectName,keyName,defaultValue,customerDefineValue,afriLanguage,vietLanguage,lastUpdate,lastUpdatedBy)
	  VALUES ('TRANSLATIONS','PARENT_COURSE_GROUP','Parent Course Group','Parent Course Group','Ouerkursusgroep','Nhóm Khóa học Phụ huynh',now(),1);
	  END IF;  

END $$
CALL V20251127103906__Alter_NameToBePrintedAndTranslationCG() $$
DROP PROCEDURE IF EXISTS V20251127103906__Alter_NameToBePrintedAndTranslationCG $$
DELIMITER ;